/*
 * Copyright 2004 by Kappich+Kniß Systemberatung, Aachen
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.communication.dataRepresentation.datavalue;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

/**
 * Diese Klasse stellt die Attribute und Funktionalitäten des Datentyps DoubleArray zur Verfügung.
 *
 * @author Kappich Systemberatung
 */
public class DoubleArrayAttribute extends DataValue {

    /** Der Double Array Wert */
    private double[] _doubleArray;

    /** Erzeugt ein neues Objekt ohne Parameter. Die Parameter werden zu einem Späteren Zeitpunkt über die read-Methode eingelesen. */
    public DoubleArrayAttribute() {
        _type = DOUBLE_ARRAY_TYPE;
    }

    /**
     * Erzeugt ein neues Objekt mit den gegebenen Parametern.
     *
     * @param doubleArray Feld mit double Werten
     */
    public DoubleArrayAttribute(double[] doubleArray) {
        _type = DOUBLE_ARRAY_TYPE;
        _doubleArray = doubleArray;
    }

    @Override
    public final Object getValue() {
        return _doubleArray;
    }

    @Override
    public final DataValue cloneObject() {
        return new DoubleArrayAttribute(_doubleArray == null ? null : _doubleArray.clone());
    }

    @Override
    public final String parseToString() {
        StringBuilder str = new StringBuilder("Double Array  : [ ");
        if (_doubleArray != null) {
            for (int i = 0; i < _doubleArray.length; ++i) {
                if (i == 0) {
                    str.append(_doubleArray[i]);
                } else {
                    str.append(" , ").append(_doubleArray[i]);
                }
            }
        }
        str.append(" ]\n");
        return str.toString();
    }

    @Override
    public final void write(DataOutputStream out) throws IOException {
        if (_doubleArray == null) {
            out.writeInt(0);
        } else {
            out.writeInt(_doubleArray.length);
            for (final double a_doubleArray : _doubleArray) {
                out.writeDouble(a_doubleArray);
            }
        }
    }

    @Override
    public final void read(DataInputStream in) throws IOException {
        int length = in.readInt();
        if (length >= 0) {
            _doubleArray = new double[length];
            for (int i = 0; i < length; ++i) {
                _doubleArray[i] = in.readDouble();
            }
        }
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final DoubleArrayAttribute that = (DoubleArrayAttribute) o;

        return Arrays.equals(_doubleArray, that._doubleArray);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(_doubleArray);
    }
}
