/*
 * Copyright 2004 by Kappich+Kniß Systemberatung, Aachen
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.communication.dataRepresentation.datavalue;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

/**
 * Diese Klasse stellt die Attribute und Funktionalitäten des Datentyps FloatArray zur Verfügung.
 *
 * @author Kappich Systemberatung
 */
public class FloatArrayAttribute extends DataValue {

    /** Der Float Array Wert */
    private float[] _floatArray;

    /** Erzeugt ein neues Objekt ohne Parameter. Die Parameter werden zu einem Späteren Zeitpunkt über die read-Methode eingelesen. */
    public FloatArrayAttribute() {
        _type = FLOAT_ARRAY_TYPE;
    }

    /**
     * Erzeugt ein neues Objekt mit den gegebenen Parametern.
     *
     * @param floatArray Feld mit Float Werten
     */
    public FloatArrayAttribute(float[] floatArray) {
        _type = FLOAT_ARRAY_TYPE;
        _floatArray = floatArray;
    }

    @Override
    public final Object getValue() {
        return _floatArray;
    }

    @Override
    public final DataValue cloneObject() {
        return new FloatArrayAttribute(_floatArray == null ? null : _floatArray.clone());
    }

    @Override
    public final String parseToString() {
        StringBuilder str = new StringBuilder("Float Array  : [ ");
        if (_floatArray != null) {
            for (int i = 0; i < _floatArray.length; ++i) {
                if (i == 0) {
                    str.append(_floatArray[i]);
                } else {
                    str.append(" , ").append(_floatArray[i]);
                }
            }
        }
        str.append(" ]\n");
        return str.toString();
    }

    @Override
    public final void write(DataOutputStream out) throws IOException {
        if (_floatArray == null) {
            out.writeInt(0);
        } else {
            out.writeInt(_floatArray.length);
            for (final float a_floatArray : _floatArray) {
                out.writeFloat(a_floatArray);
            }
        }
    }

    @Override
    public final void read(DataInputStream in) throws IOException {
        int length = in.readInt();
        if (length >= 0) {
            _floatArray = new float[length];
            for (int i = 0; i < length; ++i) {
                _floatArray[i] = in.readFloat();
            }
        }
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final FloatArrayAttribute that = (FloatArrayAttribute) o;

        return Arrays.equals(_floatArray, that._floatArray);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(_floatArray);
    }
}
