/*
 * Copyright 2004 by Kappich+Kniß Systemberatung, Aachen
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.communication.dataRepresentation.datavalue;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

/**
 * Diese Klasse stellt die Attribute und Funktionalitäten des Datentyps IntegerArray zur Verfügung.
 *
 * @author Kappich Systemberatung
 */
public class IntegerArrayAttribute extends DataValue {

    /** Der Integer Array Wert */
    private int[] _intArray;

    /** Erzeugt ein neues Objekt ohne Parameter. Die Parameter werden zu einem Späteren Zeitpunkt über die read-Methode eingelesen. */
    public IntegerArrayAttribute() {
        _type = INTEGER_ARRAY_TYPE;
    }

    /**
     * Erzeugt ein neues Objekt mit den gegebenen Parametern.
     *
     * @param intArray Feld mit Integer Werten
     */
    public IntegerArrayAttribute(int[] intArray) {
        _type = INTEGER_ARRAY_TYPE;
        _intArray = intArray;
    }

    @Override
    public final Object getValue() {
        return _intArray;
    }

    @Override
    public final DataValue cloneObject() {
        return new IntegerArrayAttribute(_intArray == null ? null : _intArray.clone());
    }

    @Override
    public final String parseToString() {
        StringBuilder str = new StringBuilder("Integer Array  : [ ");
        if (_intArray != null) {
            for (int i = 0; i < _intArray.length; ++i) {
                if (i == 0) {
                    str.append(_intArray[i]);
                } else {
                    str.append(" , ").append(_intArray[i]);
                }
            }
        }
        str.append(" ]\n");
        return str.toString();
    }

    @Override
    public final void write(DataOutputStream out) throws IOException {
        if (_intArray == null) {
            out.writeInt(0);
        } else {
            out.writeInt(_intArray.length);
            for (final int a_intArray : _intArray) {
                out.writeInt(a_intArray);
            }
        }
    }

    @Override
    public final void read(DataInputStream in) throws IOException {
        int length = in.readInt();
        if (length >= 0) {
            _intArray = new int[length];
            for (int i = 0; i < length; ++i) {
                _intArray[i] = in.readInt();
            }
        }
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final IntegerArrayAttribute that = (IntegerArrayAttribute) o;

        return Arrays.equals(_intArray, that._intArray);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(_intArray);
    }
}
