/*
 * Copyright 2018-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.main.authentication;

import java.util.Scanner;

/**
 * Implementierung eines automatisierten Login. Das Passwort bzw. der Token wird in einem UTF-16BE-kodierten Datenstrom im STDIN an die Applikation
 * übertragen.
 *
 * @author Kappich Systemberatung
 * @since 3.14
 */
public final class DirectInteractiveAuthentication implements UserProperties {
    private DirectInteractiveAuthentication() {
    }

    public static DirectInteractiveAuthentication getInstance() {
        return new DirectInteractiveAuthentication();
    }

    @Override
    public ClientCredentials getClientCredentials(final String userName, final String suffix) {
        @SuppressWarnings("IOResourceOpenedButNotSafelyClosed") Scanner scanner = new Scanner(System.in, "UTF_16BE");
        System.err.print("\u21a0");
        System.err.flush();
        return ClientCredentials.ofString(scanner.nextLine());
    }
}
