/*
 * Copyright 2006-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.main.impl.config.request.telegramManager;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationAuthority;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * Ermöglicht es, Anfragen an die Konfiguration zu stellen, die die Benutzer der Konfiguration betreffen. Beispiele hierfür sind, neue Benutzer
 * anlegen, Passwörter ändern, Einmal-Passwörter erzeugen, usw.. Für die meisten Anfragen sind spezielle Benutzerrechte erforderlich, die durch die
 * Konfiguration vor der Ausführung automatisch geprüft werden.
 *
 * @author Achim Wullenkord (AW), Kappich Systemberatung
 * @version $Revision$ / $Date$ / ($Author$)
 */
public final class ConfigurationRequestUserAdministration extends AbstractSenderReceiverCommunication {

    public ConfigurationRequestUserAdministration(ClientDavInterface connection, ConfigurationAuthority configurationAuthority,
                                                  SystemObject localApplication) throws OneSubscriptionPerSendData {
        super(connection, configurationAuthority, localApplication);
        final DataModel dataModel = connection.getDataModel();

        Aspect requestAspect = dataModel.getAspect("asp.anfrage");
        AttributeGroup requestAtg = dataModel.getAttributeGroup("atg.konfigurationsBenutzerverwaltungsAnfrageSchnittstelle");

        Aspect responseAspect = dataModel.getAspect("asp.antwort");
        AttributeGroup responseAtg = dataModel.getAttributeGroup("atg.konfigurationsBenutzerverwaltungsAnfrageSchnittstelle");

        // Sender und Empfänger anmelden
        init(requestAtg, requestAspect, responseAtg, responseAspect, null);
    }
}
