/*
 * Copyright 2004 by Kappich+Kniß Systemberatung, Aachen
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.main.impl.config.telegrams;

import de.bsvrz.dav.daf.main.impl.config.DafDataModel;
import de.bsvrz.dav.daf.main.impl.config.DafSystemObject;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/**
 * Diese Klasse stellt ein Antworttelegramm dar. Es wird eine Liste gespeichert, welche die IDs der Objekte beinhaltet.
 *
 * @author Kappich Systemberatung
 */
public class IdsToObjectsAnswer extends SystemObjectAnswerInfo {

    /** Die Objekte */
    private DafSystemObject[] _objects;

    /** Das Datenmodel */
    private DafDataModel _dataModel;

    public IdsToObjectsAnswer(DafDataModel dataModel) {
        _answerType = IDS_TO_OBJECTS_TYPE;
        _dataModel = dataModel;
    }

    /**
     * Erzeugt ein neues Objekt mit den gegebenen Parametern.
     *
     * @param objects   Liste der Objekte
     * @param dataModel Datenmodel
     */
    public IdsToObjectsAnswer(DafSystemObject[] objects, DafDataModel dataModel) {
        _answerType = IDS_TO_OBJECTS_TYPE;
        _objects = objects;
        _dataModel = dataModel;
    }

    /**
     * Gibt die Objekte zurück
     *
     * @return Liste der Objek
     */
    public final DafSystemObject[] getObjects() {
        return _objects;
    }

    public final String parseToString() {
        String str = "Objekte: \n";
        if (_objects != null) {
	        for (DafSystemObject object : _objects) {
		        if (object == null) {
                    str += "Null Objekt";
                } else {
			        str += object.parseToString();
                }
            }
        }
        return str;
    }

    public final void write(DataOutputStream out) throws IOException {
        if (_objects == null) {
            out.writeInt(0);
        } else {
            out.writeInt(_objects.length);
	        for (DafSystemObject object : _objects) {
		        if (object == null) {
                    out.writeByte(DafSystemObject.NULL_OBJECT);
                } else {
			        out.writeByte(object.getInternType());
			        object.write(out);
                }
            }
        }
    }

    public final void read(DataInputStream in) throws IOException {
        int size = in.readInt();
        if (size > 0) {
            _objects = new DafSystemObject[size];
            for (int i = 0; i < size; ++i) {
                byte internType = in.readByte();
                _objects[i] = DafSystemObject.getObject(internType, _dataModel);
                if (_objects[i] != null) {
                    _objects[i].read(in);
                }
            }
        }
    }
}
