/*
 * Copyright 2012-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.daf.
 *
 * de.bsvrz.dav.daf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.daf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.dav.daf; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.daf.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

/**
 * Minimalimplementierung eines Sets. Nur geeignet für wenige Elemente.
 *
 * @author Kappich Systemberatung
 */
@Deprecated
public class MiniSet<E> extends AbstractSet<E> {

    private MiniList<E> _innerList;

    @Override
    public Iterator<E> iterator() {
        if (_innerList != null) {
            return _innerList.iterator();
        }
        return Collections.<E>emptyList().iterator();
    }

    @Override
    public int size() {
        if (_innerList == null) {
            return 0;
        }
        return _innerList.size();
    }

    @Override
    public boolean add(final E e) {
        if (_innerList == null) {
            _innerList = new MiniList<>(e);
            return true;
        } else {
            if (_innerList.contains(e)) {
                return false;
            }
            return _innerList.add(e);
        }
    }

    @Override
    public boolean remove(final Object o) {
        if (_innerList == null) {
            return false;
        }
        return _innerList.remove(o);
    }

    @Override
    public boolean removeAll(final Collection<?> c) {
        if (_innerList == null) {
            return false;
        }
        return _innerList.removeAll(c);
    }

    @Override
    public boolean retainAll(final Collection<?> c) {
        if (_innerList == null) {
            return false;
        }
        return _innerList.retainAll(c);
    }

    @Override
    public boolean containsAll(final Collection<?> c) {
        if (_innerList == null) {
            return c.isEmpty();
        }
        return _innerList.containsAll(c);
    }

    @Override
    public void clear() {
        _innerList = null;
    }
}
