/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.pat.sysbed.
 *
 * de.bsvrz.pat.sysbed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.pat.sysbed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.pat.sysbed.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.pat.sysbed.dataview.csv;

import de.bsvrz.pat.sysbed.dataview.DataTableObject;
import de.bsvrz.pat.sysbed.dataview.selectionManagement.CellKey;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.util.List;
import java.util.Set;

/**
 * Die Interface beschreibt die Methoden, die für die Konvertierung von {@link DataTableObject DataTableObjects} zu CSV-Zeilen bei eventuellem
 * Vorliegen einer Selektion von {@link CellKey CellKeys}, nötig sind.
 */
public interface CsvConverter {

    /**
     * Diese Methode teilt dem CsvConverter {@link DataTableObject DataTableObjects} mit, und gegebenenfalls eine Selektion von {@link CellKey
     * CellKeys}. Der Rückgabewert ist {@code true}, falls sich die Spaltenstruktur durch die neuen DataTableObjects ändert (der erste Aufruf von
     * setData mit einer nicht-leeren Liste von dataTableObjects, die mindestens eine Spalte nötig machen, gibt als {@code true} zurück.
     *
     * @param dataTableObjects weitere DataTableObjects
     * @param selectedCellKeys eine Selektion von CellKeys oder {@code null}
     *
     * @return eine Spaltenstrukturänderung
     */
    boolean setData(final List<DataTableObject> dataTableObjects, @Nullable final Set<CellKey> selectedCellKeys);

    /**
     * Gibt das Trennzeichen der der CSV-Spalten zurück.
     *
     * @return das Trennzeichen
     */
    String getDelimiter();

    /**
     * Setzt das Trennzeichen für die CSV-Spalten.
     *
     * @param delimiter
     */
    void setDelimiter(final String delimiter);

    /**
     * Erzeugt eine einzelne Zeile, die als CSV-KKopfzeile genutzt werden kann. Fügt die Überschriften der drei RowHeader-Spalten hinzu, falls die
     * boolsche Variable {@code true} ist.
     *
     * @param rowHeader
     *
     * @return
     */
    String getCsvHeaderLine(final boolean rowHeader);

    /**
     * Gibt alle CSV-Zeilen zu den {@link DataTableObject DataTableObjects} des letzten Aufrufs von {@code setData} zurück. Fügt die drei
     * RowHeader-Spalten hinzu, falls die boolsche Variable {@code true} ist.
     *
     * @param rowHeader
     *
     * @return
     */
    String getCsvLines(final boolean rowHeader);
}
