/*
 * Copyright 2018-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.pat.sysbed.
 *
 * de.bsvrz.pat.sysbed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.pat.sysbed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.pat.sysbed.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.pat.sysbed.plugins.archiveinfo;

import static de.bsvrz.pat.sysbed.plugins.archiveinfo.DataView.ITEM_HEIGHT;


import de.bsvrz.dav.daf.main.archive.ArchiveDataSpecification;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.util.Set;

/**
 * Swing-Komponente für die Linke Objekt-Spalte
 *
 * @author Kappich Systemberatung
 */
public class DataRowHeader extends Component {

    private final Set<ArchiveDataSpecification> _archiveDataSpecifications;

    public DataRowHeader(final Set<ArchiveDataSpecification> archiveDataSpecifications) {
        _archiveDataSpecifications = archiveDataSpecifications;
    }

    @Override
    public void validate() {
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
        int width = 0;
        Font font = getFont();
        for (ArchiveDataSpecification row : _archiveDataSpecifications) {
            width = Math.max(width, (int) font.getStringBounds(row.getObject().getPidOrNameOrId(), fontRenderContext).getMaxX());
        }
        Dimension size = new Dimension(width + 4, _archiveDataSpecifications.size() * ITEM_HEIGHT);
        setMinimumSize(size);
        setPreferredSize(size);
        setMaximumSize(size);
        super.validate();
    }

    @Override
    public void paint(final Graphics g) {
        super.paint(g);
        g.setColor(Color.white);
        g.fillRect(0, 0, getWidth(), getHeight());
        Graphics2D graphics2D = (Graphics2D) g;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int rowIdx = 0;
        graphics2D.setPaint(Color.black);
        for (ArchiveDataSpecification row : _archiveDataSpecifications) {
            graphics2D.drawString(row.getObject().getPidOrNameOrId(), 0, (rowIdx + 1) * ITEM_HEIGHT - 4);
            rowIdx++;
        }
    }
}
