/*
 * Copyright 2010-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.pat.sysbed.
 *
 * de.bsvrz.pat.sysbed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.pat.sysbed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.pat.sysbed.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.pat.sysbed.plugins.dataavailibility;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.config.SystemObject;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JFrame;

/**
 * Der Name dieser Klasse rührt von ihrer Fähigkeit, beim Schließen des Fensters einen Receiver abzumelden.
 *
 * @author Kappich Systemberatung
 */
public class UnsubscriberFrame extends JFrame {

    /** Wird gefordert. */
    private static final long serialVersionUID = 1L;
    private final ClientDavInterface _connection;
    private final java.util.List<SystemObject> _objects;
    private final DataDescription _dataDescription;
    /** Der Receiver, der abgemeldet werden soll. */
    private ClientReceiverInterface _receiver;

    public UnsubscriberFrame(ClientDavInterface connection, List<SystemObject> objects, DataDescription dataDescription) {
        _connection = connection;
        _objects = objects;
        _dataDescription = dataDescription;
    }

    /**
     * Setzt den Receiver
     *
     * @param receiver der abgemeldet werden soll.
     */
    protected final void setReceiver(final ClientReceiverInterface receiver) {
        _receiver = receiver;
    }

    private void unsubscribe() {
        if (_receiver != null) {
            _connection.unsubscribeReceiver(_receiver, _objects, _dataDescription);
        }
    }

    /** Überschreibt die geerbte Methode und fügt bei Schließen des Fensters die Abmeldung des Receivers hinzu. */
    @Override
    protected void processWindowEvent(final WindowEvent e) {
        super.processWindowEvent(e);

        if (e.getID() == WindowEvent.WINDOW_CLOSING) {
            unsubscribe();
        }
    }

}
