/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.pat.sysbed.
 *
 * de.bsvrz.pat.sysbed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.pat.sysbed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.pat.sysbed.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

/*
 
 
  @author Kappich Systemberatung
 */

package de.bsvrz.pat.sysbed.plugins.subscriptions;

import de.bsvrz.dav.daf.main.ApplicationSubscriptionInfo;
import de.bsvrz.dav.daf.main.ClientConnectionState;
import de.bsvrz.dav.daf.main.ClientSubscriptionInfo;
import de.bsvrz.sys.funclib.kappich.selectionlist.ObjectListRenderer;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/**
 * @author Kappich Systemberatung
 * @version $Revision: 0000 $
 */
public final class IconRenderer implements ObjectListRenderer<Object> {
    private static final IconRenderer ourInstance = new IconRenderer();
    private final Map<String, Icon> _cache = new ConcurrentHashMap<>();

    private IconRenderer() {
    }

    public static IconRenderer getInstance() {
        return ourInstance;
    }

    private static Icon loadImageFromResource(final String name) {
        URL resource = IconRenderer.class.getResource(name + ".png");
        if (resource == null) {
            return null;
        }
        return new ImageIcon(resource);
    }

    @Override
    public String getText(final Object obj) {
        return obj.toString();
    }

    @Override
    public Icon getIcon(final Object obj) {
        ClientConnectionState state = null;
        String type = "";
	    if (obj instanceof ClientSubscriptionInfo.ClientSendingSubscription sendingSubscription) {
            state = sendingSubscription.getConnectionState();
            type = sendingSubscription.isSource() ? "source" : "sender";
        }
	    if (obj instanceof ClientSubscriptionInfo.ClientReceivingSubscription receivingSubscription) {
            state = receivingSubscription.getConnectionState();
            type = receivingSubscription.isDrain() ? "drain" : "receiver";
        }
	    if (obj instanceof ApplicationSubscriptionInfo.ApplicationSendingSubscription sendingSubscription) {
            state = ClientConnectionState.FromLocalOk;
            type = sendingSubscription.isSource() ? "source" : "sender";
        }
	    if (obj instanceof ApplicationSubscriptionInfo.ApplicationReceivingSubscription receivingSubscription) {
            state = ClientConnectionState.FromLocalOk;
            type = receivingSubscription.isDrain() ? "drain" : "receiver";
        }
        if (state == ClientConnectionState.FromRemoteOk) {
            type += "_in";
        } else if (state != ClientConnectionState.FromLocalOk) {
            type += "_out";
            if (state != ClientConnectionState.ToRemoteOk) {
                type += "_err";
            }
        }
        return loadImage(type);
    }

    private Icon loadImage(final String type) {
        return _cache.computeIfAbsent(type, IconRenderer::loadImageFromResource);
    }
}
