/*
 * Copyright 2011-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.pat.sysbed.
 *
 * de.bsvrz.pat.sysbed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.pat.sysbed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.pat.sysbed.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.pat.sysbed.plugins.subscriptions;

import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DavApplication;
import de.bsvrz.dav.daf.main.config.Pid;
import de.bsvrz.dav.daf.main.config.SystemObject;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.WindowConstants;

/**
 * @author Kappich Systemberatung
 * @version $Revision: 11390 $
 */
public class SubscriptionInfoFrame extends JFrame {

    private final JComboBox<Object> _davObjSelection;

    private final JButton _refreshButton;

    private final Container _pane;

    private final ClientDavInterface _connection;

    private final SystemObject _systemObject;

    private final AttributeGroup _attributeGroup;

    private final Aspect _aspect;

    private final int _simulationVariant;

    private SubscriptionsPanel _subscriptionsPanel;

    public SubscriptionInfoFrame(final ClientDavInterface connection, final SystemObject systemObject, final AttributeGroup attributeGroup,
                                 final Aspect aspect, final int simulationVariant) {
        _connection = connection;
        _systemObject = systemObject;
        _attributeGroup = attributeGroup;
        _aspect = aspect;
        _simulationVariant = simulationVariant;
        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Anmeldungsinfo");

        _pane = getContentPane();
        _pane.setLayout(new BorderLayout());

        _pane.add(getHeaderPanel(_attributeGroup, _aspect, _systemObject), BorderLayout.NORTH);
        _subscriptionsPanel = new SubscriptionsPanel((ClientDavConnection) _connection, systemObject, _attributeGroup.getAttributeGroupUsage(_aspect),
                                                     (short) simulationVariant, _connection.getLocalDav());
        _pane.add(_subscriptionsPanel, BorderLayout.CENTER);

        final JPanel buttonpanel = new JPanel();
        buttonpanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
        _refreshButton = new JButton("Aktualisieren");
        _refreshButton.addActionListener(new RefreshListener());
        java.util.List<SystemObject> davObjects = _connection.getDataModel().getType(Pid.Type.DAV_APPLICATION).getObjects();
        Object[] objects = davObjects.toArray(new Object[0]);
        Arrays.sort(objects);
        _davObjSelection = new JComboBox<>(objects);
        _davObjSelection.setEditable(false);
        _davObjSelection.setSelectedItem(_connection.getLocalDav());
        buttonpanel.add(_davObjSelection);
        buttonpanel.add(_refreshButton);
        _pane.add(buttonpanel, BorderLayout.SOUTH);
    }

    /**
     * Stellt die ausgewählte Datenidentifikation dar.
     *
     * @param attributeGroup die darzustellende Attributgruppe
     * @param aspect         den darzustellenden Aspekt
     * @param systemObject   das darzustellende Systemobjekt
     *
     * @return die ausgewählte Datenidentifikation als JPanel
     */
    private static JPanel getHeaderPanel(final AttributeGroup attributeGroup, final Aspect aspect, final SystemObject systemObject) {
        JLabel atgLabel = new JLabel("Attributgruppe: ");
        JLabel aspLabel = new JLabel("Aspekt: ");
        JLabel objLabel = new JLabel("Objekt: ");

        JTextField atgTextField = new JTextField(attributeGroup.getNameOrPidOrId());
        atgTextField.setEditable(false);
        atgTextField.setFocusable(false);
        JTextField aspTextField = new JTextField(aspect.getNameOrPidOrId());
        aspTextField.setEditable(false);
        aspTextField.setFocusable(false);
        JTextField objTextField = new JTextField(systemObject.getNameOrPidOrId());
        objTextField.setEditable(false);
        objTextField.setFocusable(false);

        // anordnen der Komponenten
        GridBagConstraints gbc;
        GridBagLayout gbl = new GridBagLayout();
        JPanel headerPanel = new JPanel();
        headerPanel.setLayout(gbl);

        // Attributgruppe
        gbc = makegbc(0, 0, 1, 1);
        gbc.anchor = GridBagConstraints.WEST;
        gbl.setConstraints(atgLabel, gbc);
        headerPanel.add(atgLabel);

        gbc = makegbc(1, 0, 1, 1);
        gbc.weightx = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbl.setConstraints(atgTextField, gbc);
        headerPanel.add(atgTextField);

        // Aspekt
        gbc = makegbc(0, 1, 1, 1);
        gbc.anchor = GridBagConstraints.WEST;
        gbl.setConstraints(aspLabel, gbc);
        headerPanel.add(aspLabel);

        gbc = makegbc(1, 1, 1, 1);
        gbc.weightx = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbl.setConstraints(aspTextField, gbc);
        headerPanel.add(aspTextField);

        // Objekt
        gbc = makegbc(0, 2, 1, 1);
        gbc.anchor = GridBagConstraints.WEST;
        gbl.setConstraints(objLabel, gbc);
        headerPanel.add(objLabel);

        gbc = makegbc(1, 2, 1, 1);
        gbc.weightx = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbl.setConstraints(objTextField, gbc);
        headerPanel.add(objTextField);

        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Datenidentifikation"));
        panel.add(headerPanel, BorderLayout.WEST);

        return panel;
    }

    /**
     * Hilfsmethode für das GridBagLayout zur Positionierung der Elemente.
     *
     * @param x      die x-Position im Grid
     * @param y      die y-Position im Grid
     * @param width  gibt die Anzahl der Spalten an, die die Komponente nutzen soll
     * @param height gibt die Anzahl der Zeilen an, die die Komponente nutzen soll
     *
     * @return die Rahmenbedingungen für eine Komponente
     */
    @SuppressWarnings("SameParameterValue")
    private static GridBagConstraints makegbc(int x, int y, int width, int height) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.insets = new Insets(1, 5, 1, 1);
        return gbc;
    }

    public void start() {
        pack();
        setLocationRelativeTo(null);
        setVisible(true);

        _refreshButton.requestFocusInWindow(); // Damit nicht eine der SelectionLists den Fokus hat!
    }

    private class RefreshListener implements ActionListener {

        public void actionPerformed(final ActionEvent e) {
            final SubscriptionsPanel subscriptionsPanel =
                new SubscriptionsPanel((ClientDavConnection) _connection, _systemObject, _attributeGroup.getAttributeGroupUsage(_aspect),
                                       (short) _simulationVariant, (DavApplication) _davObjSelection.getSelectedItem());
            _pane.remove(_subscriptionsPanel);
            _pane.add(subscriptionsPanel, BorderLayout.CENTER);
            _subscriptionsPanel = subscriptionsPanel;
            pack();
        }
    }

}
