/*
 * Copyright 2004 by Kappich+Kniß Systemberatung Aachen (K2S)
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.pat.sysbed.
 *
 * de.bsvrz.pat.sysbed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.pat.sysbed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.pat.sysbed.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.pat.sysbed.preselection.lists;

import de.bsvrz.dav.daf.main.config.SystemObject;
import java.util.Collection;

/**
 * Interface, um ein Filter-Objekt bei der Klasse {@code PreselectionLists} anzumelden. Wenn die Listen des {@link PreselectionLists}-Panels
 * zusätzlich nach weiteren Kriterien gefiltert werden sollen, muss die Methode {@link #applyFilter} implementiert werden. Welche Liste gefiltert
 * werden soll, kann mittels Konstanten, die dieses Interface zur Verfügung stellt, bestimmt werden.
 *
 * @author Kappich Systemberatung
 */
public interface PreselectionListsFilter {

    /**
     * Die zu filternde Liste der {@code applyFilter}-Methode: Objekt
     *
     * @see #applyFilter(int, java.util.Collection)
     */
    int OBJECT_LIST = 0;

    /**
     * Die zu filternde Liste der {@code applyFilter}-Methode: Objekttyp
     *
     * @see #applyFilter(int, java.util.Collection)
     */
    int OBJECTTYPE_LIST = 1;

    /**
     * Die zu filternde Liste der {@code applyFilter}-Methode: Attributgruppe
     *
     * @see #applyFilter(int, java.util.Collection)
     */
    int ATTRIBUTEGROUP_LIST = 2;

    /**
     * Die zu filternde Liste der {@code applyFilter}-Methode: Aspekt
     *
     * @see #applyFilter(int, java.util.Collection)
     */
    int ASPECT_LIST = 3;

    /**
     * Die Methode muss von der Anwendung implementiert werden, wenn eine der Listen des {@link PreselectionLists}-Panels zusätzlich nach weiteren
     * Kriterien gefiltert werden soll. Welche Liste gefiltert werden soll, kann mittels der Konstanten des  bestimmt werden.
     *
     * @param whichList gibt an, welche Liste übergeben wird
     * @param list      die zu filternde Liste
     *
     * @return die gefilterte Liste
     */
    Collection<? extends SystemObject> applyFilter(int whichList, Collection<? extends SystemObject> list);
}
