/*
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.testumg.
 *
 * de.kappich.pat.testumg is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.testumg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.testumg.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.testumg.util;

import static org.junit.Assert.assertEquals;


import de.bsvrz.dav.daf.main.config.management.consistenycheck.ConsistencyCheckResultInterface;

/**
 * Diese Klasse prüft das Ergebnis einer Konsistenzprüfung. Weicht das erwartete Ergebnis vom Prüfergebnis ab, so wird ein {@link AssertionError}
 * geworfen.
 *
 * @author Kappich Systemberatung
 */
public final class ConsistencyResultChecker {

    /**
     * Prüft, ob das Ergebnis der Konsistenzprüfung mit den erwarteten Ergebnis übereinstimmt. Ist das nicht der Fall, wird ein {@link AssertionError}
     * geworfen.
     *
     * @param consistencyResult          Ergebnis, dass überprüft werden soll.
     * @param expectedInterferenceErrors Anzahl Interferenzfehler, die erwartet werden. 0 bedeutet, dass es zu keinen Interferenzfehler gekommen sein
     *                                   darf.
     * @param expectedLocalErrors        Anzahl lokaler Fehler, die erwartet werden. 0 bedeutet, dass es zu keinem lokalen Fehler gekommen sein darf.
     * @param expectedWarnings           Anzahl Warnungen. 0 bedeutet, dass es zu keiner Warnung gekommen sein darf.
     *
     * @throws AssertionError Die Ergebnisse der Konsistenzprüfung stimmten nicht mit den erwarteten Werte überein.
     */
    public static final void checkResult(final ConsistencyCheckResultInterface consistencyResult, final int expectedInterferenceErrors,
                                         final int expectedLocalErrors, final int expectedWarnings) {
        assertEquals("Anzahl Interferenzfehler fehlerhaft", expectedInterferenceErrors, consistencyResult.getInterferenceErrors().size());
        assertEquals("Anzahl lokaler Fehler fehlerhaft", expectedLocalErrors, consistencyResult.getLocalErrors().size());

        if (expectedWarnings != consistencyResult.getWarnings().size()) {
            System.out.println(
                "Unterschiede in der Anzahl Warnungen bei der Konsistenzprüfung werden ignoriert, erwartet: " + expectedWarnings + ", tatsächlich: " +
                consistencyResult.getWarnings().size());
        }
    }
}
