/*
 * Copyright 2005 by Kappich+Kniß Systemberatung Aachen (K2S)
 * Copyright 2018-2020 by Kappich Systemberatung, Aachen
 * Copyright 2021 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.kappich.pat.testumg.
 *
 * de.kappich.pat.testumg is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.testumg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.testumg.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.kappich.pat.testumg.util;

import de.bsvrz.dav.daf.main.ApplicationCloseActionHandler;
import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientDavParameters;
import de.bsvrz.dav.daf.main.NormalCloser;
import de.bsvrz.dav.daf.main.authentication.ClientCredentials;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;

/**
 * Diese Klasse meldet sich beim Datenverteiler an. Es muss dafür gesorgt werden, dass der Konfiguration der Benutzer, mit dem sich die Klasse
 * anmeldet, bekannt ist.
 * <p>
 * Manche Konstruktoren der Klasse verlassen sich auf gewisse Standardwerte, die in Zukunft geändert werden könnten und sind deshalb {@link
 * Deprecated}. Es ist einfacher, z. B. {@link SingleDavStarter#connect()} zu benutzen.
 *
 * @author Kappich+Kniß Systemberatung Aachen (K2S)
 * @author Achim Wullenkord (AW)
 * @version $Revision$ / $Date$ / ($Author$)
 */
public class CreateClientDavConnection {

    /** bestimmt wie oft gewartet wird */
    private final int _maxWaitCycles = 20;
    private ClientDavInterface _connection;

    /**
     * Erzeugt eine Verbindung zum DaV mit dem Benutzer Tester und dem Passwort geheim.
     *
     * @param applicationName Name der Applikation.
     */
    @Deprecated
    public CreateClientDavConnection(String applicationName) {
        this("Tester", "geheim", applicationName);
    }

    /** Erstellt eine Verbindung zum Datenverteiler mit dem Benutzernamen "Tester" und dem Password "geheim". */
    @Deprecated
    public CreateClientDavConnection() {
        this(null);
    }

    @Deprecated
    public CreateClientDavConnection(String user, String password) {
        this(user, password, null);
    }

    @Deprecated
    public CreateClientDavConnection(String user, String password, String applicationName) {
        this(user, password, applicationName, null);
    }

    @Deprecated
    public CreateClientDavConnection(String user, ClientCredentials clientCredentials) {
        this(user, clientCredentials, null);
    }

    @Deprecated
    public CreateClientDavConnection(String user, ClientCredentials clientCredentials, String applicationName) {
        this(user, clientCredentials, applicationName, null);
    }

    public CreateClientDavConnection(final String user, final String password, final String applicationName,
                                     ClientDavParameters clientDavParameters) {
        this(user, ClientCredentials.ofString(password), applicationName, clientDavParameters);
    }

    /**
     * Erstellt eine Verbindung zum Datenverteiler mit den angegebenen Eigenschaften
     *
     * @param user                Benutzer zur Authentifizierung
     * @param clientCredentials   Passwort zur Authentifizierung
     * @param applicationName     Name der Applikation oder {@code null}, wenn der Name nicht gesetzt werden soll.
     * @param clientDavParameters Verbindungsparameter oder {@code null}, wenn Defaultparameter verwendet werden sollen.
     */
    public CreateClientDavConnection(final String user, final ClientCredentials clientCredentials, final String applicationName,
                                     ClientDavParameters clientDavParameters) {
        this(user, clientCredentials, applicationName, clientDavParameters, null, 0);
    }

    /**
     * Erstellt eine Verbindung zum Datenverteiler mit den angegebenen Eigenschaften
     *
     * @param user                Benutzer zur Authentifizierung
     * @param clientCredentials   Passwort zur Authentifizierung
     * @param applicationName     Name der Applikation oder {@code null}, wenn der Name nicht gesetzt werden soll.
     * @param clientDavParameters Verbindungsparameter oder {@code null}, wenn Defaultparameter verwendet werden sollen.
     * @param davHostname         {@code null}, falls die Standard-Datenverteiler-Adresse verwendet werden soll, ansonsten IP-Adresse bzw. Domainname
     *                            des Datenverteilers
     * @param davTcpPort          {@code 0}, falls die Standard-Datenverteiler-TCP-Portnummer verwendet werden soll, ansonsten die TCP-Portnummer des
     *                            Datenverteilers
     */
    public CreateClientDavConnection(final String user, final ClientCredentials clientCredentials, @Nullable final String applicationName,
                                     @Nullable ClientDavParameters clientDavParameters, final String davHostname, final int davTcpPort) {
        try {
            // Falls die TCP-Portnummer nicht geändert wurde, dann wird für die Test ein Offset für die Portnummer verwendet, um Konflikte mit anderen
            // Umgebungen zu vermeiden
            if (clientDavParameters == null) {
                clientDavParameters = new ClientDavParameters();
            } else {
                // Kopie erzeugen, da die Einstellungen hier verändert werden und vom Caller manchmal für zwei Verbindungen benutzt werden
                clientDavParameters = clientDavParameters.clone();
            }
            if (clientDavParameters.getDavCommunicationSubAddress() == 8083) {
                clientDavParameters.setDavCommunicationSubAddress(8083 + DaVStarter.getDavPortNumberOffset());
            }

            if (davHostname != null) {
                clientDavParameters.setDavCommunicationAddress(davHostname);
            }
            if (davTcpPort != 0) {
                clientDavParameters.setDavCommunicationSubAddress(davTcpPort);
            }

            if (applicationName != null) {
                clientDavParameters.setApplicationName(applicationName);
            }

            _connection = new ClientDavConnection(clientDavParameters);

//			_connection.setCloseHandler(new NormalCloserForTest(applicationName));
            _connection.setCloseHandler(new NormalCloser());

            _connection.connect();
            _connection.login(user, clientCredentials);
        } catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException(ex);
        }
    }

    @Deprecated
    public static ClientDavInterface createConnection(final String applicationName) {
        return new CreateClientDavConnection(applicationName).getConnection();
    }

    public synchronized ClientDavInterface getConnection() {
        for (int nr = 0; nr < _maxWaitCycles; nr++) {
            if (_connection != null) {
                return _connection;
            } else {
                try {
                    Thread.sleep(100);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        }
        throw new IllegalStateException("Verbindung konnte nicht aufgebaut werden");
    }

    private class NormalCloserForTest implements ApplicationCloseActionHandler {

        private final String _applicationName;

        /** Konstruktor erzeugt ein Objekt dieser Klasse. */
        public NormalCloserForTest(final String applicationName) {
            _applicationName = applicationName;
        }

        public final void close(String error) {
            if (System.out != null) {
                System.out.println("Der CloseHandler wird für folgende Applikation gestartet: " + _applicationName);
                Thread.dumpStack();
                System.out.flush();
            }
        }
    }
}
