/*
 * Copyright 2018-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.testumg.
 *
 * de.kappich.pat.testumg is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.testumg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.testumg.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.testumg.util;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import java.nio.file.Path;

/**
 * Interface für Datenverteiler-Testumgebungen, damit Klassen wie {@link de.bsvrz.dav.daf.main.config.DavApplication} eine Schnittstelle haben, um
 * Informationen anzufragen und gleichzeitig unter mehreren Testumgebungen funktionieren.
 *
 * @author Kappich Systemberatung
 */
public interface DafApplicationEnvironment {

    /**
     * Erstellt eine Datenverteilerverbindung
     *
     * @return Datenverteilerverbindung
     */
    ClientDavInterface connect();

    /**
     * Gibt das Wurzelverzeichnis der Testumgebung zurück. Hier können allgemeien daten abgelegt werden
     *
     * @return Wurzelverzeichnis
     */
    Path getRootDir();

    /**
     * Gibt das datenverteilerspezifische Verzeichnis der Testumgebung zurück
     *
     * @return datenverteilerspezifische Verzeichnis der Testumgebung
     */
    Path getWorkingDirectory();

    /**
     * Gibt den Port zurück, über den sich Applikationen mit dem Datenverteiler verbinden sollen
     *
     * @return Port
     */
    int getAppPort();

    /**
     * Gibt die {@link FakeParamApp} der Testumgebung zurück
     *
     * @return FakeParamApp
     */
    FakeParamApp getFakeParamApp();

    /**
     * Gibt den KV zurück
     *
     * @return KV-Pid
     */
    String getConfigurationAuthority();

    /**
     * Setzt die Art der Parametrierungs-Applikation
     *
     * @param paramAppType Typ der Parametrierung
     */
    void setParamAppType(ParamAppType paramAppType);
}
