/*
 * Copyright 2006-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.testumg.
 *
 * de.kappich.pat.testumg is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.testumg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.testumg.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.testumg.util;

import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.management.ConfigAreaAndVersion;
import de.bsvrz.puk.config.configFile.datamodel.ConfigDataModel;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * Alte Klasse zum importieren und aktivieren von Konfigurationsbereichen. Die Aufgabe dieser Klasse ist es Bereiche zu importieren und zu aktivieren.
 * Diese Klasse wird in JUnit-Tests benötigt um redundanten Code zu verhindern. Die Aufrufparameter der einzelnen Methoden sind einfach gehalten und
 * stellen nicht die volle funktionalität zur Verfügung. Beim Import zum Beispiel kann nur eine Datei angegeben werden, die Importiert werden soll.
 * Dies ist ausreichend da meistens nur ein Bereich importiert und getestet werden soll.
 *
 * @author Achim Wullenkord (AW), Kappich Systemberatung
 * @version $Revision$ / $Date$ / ($Author$)
 */
@Deprecated
public final class DeprecatedConfigurationController {

    /**
     * Importiert und aktiviert einen Konfigurationsbereich mittels einer Versorgungsdatei. Dafür wird ein Datenmodell gestartet, dieses importiert
     * den Bereich und aktiviert ihn.
     *
     * @param configArea      Versorgungsdatei, die importiert werden soll
     * @param version         Version, in der der Bereich aktiviert werden soll
     * @param configAdminFile Verwaltungsdatei mit der die Konfiguration gestartet wird
     *
     * @return Konfiguration, in der die Versorgungsdatei aktiviert wurde. Diese Konfiguration kann direkt benutzt werden
     *
     * @throws ConfigurationChangeException Fehler beim importieren/aktivieren des Bereich
     */
    public static ConfigDataModel importAndActivateConfigArea(final File configArea, int version, File configAdminFile)
        throws ConfigurationChangeException {
        ConfigDataModel importAndActivateDataModel = new ConfigDataModel(configAdminFile);
        // Pid des zu importierenden Bereichs rausfinden
        final String areaPid = configArea.getName().replace(".xml", "");
        System.out.println("Pid des Bereichs: " + areaPid);
        final List<String> helper = new ArrayList<>();
        helper.add(areaPid);
        // Bereich importieren
        importAndActivateDataModel.importConfigurationAreas(configArea.getParentFile(), helper);
        // Bereich aktivieren
        final ConfigurationArea importedConfigArea = importAndActivateDataModel.getAllConfigurationAreas().get(areaPid);
        List<ConfigAreaAndVersion> areaAndVersion = new ArrayList<>();
        areaAndVersion.add(new ConfigAreaAndVersion(importedConfigArea, (short) version));
        importAndActivateDataModel.activateConfigurationAreas(areaAndVersion);

        // Alle Daten speichern (auch den neuen Bereich). Gleichzeitig werden die lock-Dateien freigegeben, da die Konfiguration neu gestartet wird.
        importAndActivateDataModel.close();

        return new ConfigDataModel(configAdminFile);
    }
}
