/*
 * Copyright 2016-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.testumg.
 *
 * de.kappich.pat.testumg is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.testumg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.testumg.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.testumg.util;

import de.bsvrz.dav.dav.main.Transmitter;
import de.bsvrz.puk.config.main.ConfigurationApp;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.puk.param.main.ParamApp;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * Liste mit den verschiedenen alten (und neuen) Datenverteilerversionen, die im {@link MultiDavTestEnvironment} zum Testen benutzt werden können
 *
 * @author Kappich Systemberatung
 */
public enum ReleaseVersion {

    Current(null, Transmitter.class.getCanonicalName(), ConfigurationApp.class.getCanonicalName(), ParamApp.class.getCanonicalName()),
    V3_8_0("http://downloads.kappich.de/kernsoftware/ks3801051f/kernsoftware-pakete.zip", "de.bsvrz.dav.dav.main.Transmitter",
           "de.bsvrz.puk.config.main.ConfigurationApp", "de.kappich.puk.param.main.ParamApp"),
    V3_6_5("http://downloads.kappich.de/kernsoftware/ks365fcm5f16/kernsoftware-pakete.zip", "de.bsvrz.dav.dav.main.Transmitter",
           "de.bsvrz.puk.config.main.ConfigurationApp", "de.kappich.puk.param.main.ParamApp"),
    V3_5_5("http://downloads.kappich.de/kernsoftware/ks351542012/kernsoftware-3.5.0/kernsoftware-pakete-3.5.5.zip",
           "de.bsvrz.dav.dav.main.Transmitter", "de.bsvrz.puk.config.main.ConfigurationApp", "de.kappich.puk.param.main.ParamApp"),
    V3_4_10("http://downloads.kappich.de/kernsoftware/ks3410-6640/kernsoftware-3.4.10/kernsoftware-pakete.zip", "de.bsvrz.dav.dav.main.Transmitter",
            "de.bsvrz.puk.config.main.ConfigurationApp", "de.kappich.puk.param.main.ParamApp"),
    V3_3("http://downloads.kappich.de/kernsoftware/k889-2w5e/kernsoftware-3.3.zip", "de.bsvrz.dav.dav.main.Transmitter",
         "de.bsvrz.puk.config.main.ConfigurationApp", "de.kappich.puk.param.main.ParamApp"),
    V3_2b4("http://downloads.kappich.de/kernsoftware/j34k-y9/ks.zip", "stauma.dav.serverside.Transmitter",
           "puk.configuration.management.ConfigurationApp", "puk.param.ParamApp"),
    ;

    private final URL _url;
    private final String _transmitterClass;
    private final String _configurationClass;
    private final String _paramClass;

    /**
     * Erstellt eine Instanz
     *
     * @param url                Download-URL der Kernsoftware
     * @param transmitterClass   Klassenname des Datenverteilers
     * @param configurationClass Klassenname der Konfiguration
     * @param paramClass         Klassenname der Parametrierung
     */
    ReleaseVersion(final String url, final String transmitterClass, final String configurationClass, final String paramClass) {
        _transmitterClass = transmitterClass;
        _configurationClass = configurationClass;
        _paramClass = paramClass;
        if (url == null) {
            _url = null;
        } else {
            try {
                _url = new URL(url);
            } catch (MalformedURLException e) {
                throw new AssertionError(e);
            }
        }
    }

    @Nullable
    public URL getUrl() {
        return _url;
    }

    public String getTransmitterClass() {
        return _transmitterClass;
    }

    public String getConfigurationClass() {
        return _configurationClass;
    }

    public String getParamClass() {
        return _paramClass;
    }

    public boolean min(final ReleaseVersion releaseVersion) {
        return ordinal() <= releaseVersion.ordinal();
    }
}
