/*
 * Copyright 2011-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.testumg.
 *
 * de.kappich.pat.testumg is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.testumg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.testumg.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.testumg.util.connections;

import de.bsvrz.dav.daf.communication.lowLevel.ConnectionInterface;
import de.bsvrz.dav.daf.communication.lowLevel.ParameterizedConnectionInterface;
import de.bsvrz.dav.daf.communication.lowLevel.ServerConnectionInterface;
import de.bsvrz.dav.daf.communication.tcpCommunication.TCP_IP_ServerCommunication;
import java.net.Socket;

/**
 * Server-Schnittstelle, die {@link LocalDavDavConnection}-Verbingungen erzeugt.
 *
 * @author Kappich Systemberatung
 * @see LocalDavDavConnection
 */
public class LocalDavDavConnectionServer extends TCP_IP_ServerCommunication implements ParameterizedConnectionInterface, ServerConnectionInterface {

    private String _parameters;

    public String getParameters() {
        return _parameters;
    }

    public void setParameters(final String parameters) {
        _parameters = parameters;
    }

    public ConnectionInterface getPlainConnection() {
        return new LocalDavDavConnection(_parameters);
    }

    @Override
    public ConnectionInterface getConnectionTo(final Socket socket) {
        if (_parameters == null) {
            return super.getConnectionTo(socket);
        }
        return new LocalDavDavConnection(socket, _parameters);
    }

    public String getPlainConnectionName() {
        return LocalDavDavConnection.class.getName();
    }
}
