/*
 * Copyright 2014-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.testumg.
 *
 * de.kappich.pat.testumg is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.testumg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.testumg.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.testumg.util.connections;

import java.util.ArrayList;
import java.util.List;

/**
 * Interne Klasse, mit dem an einem Datenverteiler für Tests gespeichert wird, hinter welchen Adressen und Portnummern sich welche Datenverteiler
 * befinden. Diese Informationen werden am datenverteielr als String serialisert gespeichert und dann von {@link LocalDavDavConnection} mit dieser
 * Klasse ausgelesen benutzt.
 *
 * @author Kappich Systemberatung
 */
public class MultiDavProtocolParameter {

    private final DavInformation[] _davInformations;

    private final String _myName;

    public MultiDavProtocolParameter(final DavInformation[] davInformations, final String myName) {
        _davInformations = davInformations;
        _myName = myName;
    }

    public MultiDavProtocolParameter(final String s) {
        int start = 0;
        int end = s.indexOf('#', start);
        if (end == -1) {
            _myName = "";
            _davInformations = new DavInformation[0];
            return;
        }
        _myName = s.substring(0, end);
        start = end + 1;
        final List<DavInformation> result = new ArrayList<>();
        while (true) {
            end = s.indexOf('#', start);
            if (end == -1) {
                break;
            }
            result.add(new MyDavInformation(s.substring(start, end)));
            start = end + 1;
        }
        _davInformations = result.toArray(new DavInformation[0]);
    }

    public String getMyName() {
        return _myName;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(_myName).append("#");
        for (DavInformation davInformation : _davInformations) {
            stringBuilder.append(davInformation.getName()).append(":");
            stringBuilder.append(davInformation.getAddress()).append(":");
            stringBuilder.append(davInformation.getPort()).append("#");
        }
        return stringBuilder.toString();
    }

    public String getOtherName(final String address, final int port) {
        for (DavInformation davInformation : _davInformations) {
            if (davInformation.getAddress().equals(address) && davInformation.getPort() == port) {
                return davInformation.getName();
            }
        }
        return address + ":" + port;
    }

    public boolean has(final String address, final int port) {
        for (DavInformation davInformation : _davInformations) {
            if (davInformation.getAddress().equals(address) && davInformation.getPort() == port) {
                return true;
            }
        }
        return false;
    }

    /**
     * @author Kappich Systemberatung
     */
    public static class MyDavInformation implements DavInformation {
        private int _port;
        private String _address;
        private String _name;

        public MyDavInformation(final String s) {
            String[] split = s.split(":");
            _name = split[0];
            _address = split[1];
            _port = Integer.parseInt(split[2]);
        }

        @Override
        public String getName() {
            return _name;
        }

        @Override
        public String getAddress() {
            return _address;
        }

        @Override
        public int getPort() {
            return _port;
        }
    }
}
