/*
 * Copyright 2013-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.testumg.
 *
 * de.kappich.pat.testumg is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.testumg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.testumg.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.testumg.util.connections;

import de.bsvrz.dav.daf.communication.dataRepresentation.datavalue.SendDataObject;
import de.bsvrz.dav.daf.communication.lowLevel.ConnectionInterface;
import de.bsvrz.dav.daf.communication.lowLevel.HighLevelCommunicationCallbackInterface;
import de.bsvrz.dav.daf.communication.lowLevel.LowLevelCommunication;
import de.bsvrz.dav.daf.communication.lowLevel.telegrams.DataTelegram;
import de.bsvrz.dav.daf.main.ConnectionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

/**
 * Abstrakte Implementierung von {@link ConnectionInterface}, die alle versendeten Telegramme zusätzlich in der abstrakten Methode {@link
 * #telegramSend(DataTelegram)} ausgibt.
 * <p>Mit dieser Klasse kann damit z. B. testweise die komplette Kommunikation zwischen Softwareeinheiten ausgegeben und analysiert werden.
 *
 * @author Kappich Systemberatung
 */
public abstract class WiretapOutputStream extends DelayOutputStream implements ConnectionInterface {

    private final LowLevelCommunication _lowLevelCommunication;
    private final PipedOutputStream _out = new PipedOutputStream();
    private InputStream _in;

    public WiretapOutputStream(final OutputStream outputStream, final long transmissionDelay, final double maxFlowRate) {
        super(outputStream, transmissionDelay, maxFlowRate);
        try {
            _in = new PipedInputStream(_out);
            _lowLevelCommunication = new LowLevelCommunication(this, 1000000, 1000000, 30000, 30000, LowLevelCommunication.NORMAL_MODE, true);
        } catch (Exception e) {
            throw new IllegalStateException(e);
        }
        _lowLevelCommunication.setHighLevelComponent(new HighLevelCommunicationCallbackInterface() {
            @Override
            public void update(final DataTelegram telegram) {
                telegramSend(telegram);
            }

            @Override
            public void disconnected(final boolean error, final String message) {
            }

            @Override
            public void updateConfigData(final SendDataObject receivedData) {
            }
        });
    }

    public abstract void telegramSend(final DataTelegram telegram);

    @Override
    protected void enqueue(final byte[] bytes) throws IOException {
        _out.write(bytes);
        super.enqueue(bytes);
    }

    @Override
    public String getMainAdress() {
        return "Foo";
    }

    @Override
    public int getSubAdressNumber() {
        return 0;
    }

    @Override
    public OutputStream getOutputStream() {
        return this;
    }

    @Override
    public InputStream getInputStream() {
        return _in;
    }

    @Override
    public void connect(final String mainAdress, final int subAdressNumber) throws ConnectionException {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean isConnected() {
        return true;
    }

}
