/*
 * Copyright 2011-2021 Connect2id Ltd. and others
 * Copyright 2021 by DTV-Verkehrsconsult, Aachen
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.sys.funclib.srp6;


import java.math.BigInteger;
import java.util.Arrays;


/**
 * Hexadecimal encoding and decoding utility.
 *
 * <p>Obtained from Apache Xerces and Aduna Software code on java2s.com.
 *
 * @author Vladimir Dzhuvinov
 * @author John Kim
 * @author others
 */
public class BigIntegerUtils {

	/**
	 * Encodes the specified big integer into a hex string.
	 *
	 * @param bigint the value to convert to a hexidecimal string
	 *
	 * @return The resulting hex encoded string or {@code null} if the
	 *         input is undefined.
	 */
	public static String toHex(final BigInteger bigint) {
	
		if (bigint == null)
			return null;
	
		return bigint.toString(16);
	}

	/**
	 * Decodes the specified hex string into a big integer.
	 *
	 * @param hex The hex encoded string to decode.
	 *
	 * @return The resulting big integer or {@code null} if decoding
	 *         failed.
	 */
	public static BigInteger fromHex(final String hex) {

		if (hex == null)
			return null;
	
		try {
			return new BigInteger(hex, 16);

		} catch (NumberFormatException e) {

			return null;
		}
	}

	/**
	 * Converts a byte array to a positive BigInteger
	 *
	 * @param bytes byte array in big endian unsigned RFC2945 format
	 *
	 * @return positive BigInteger containing the data of the supplied byte array
	 */
	public static BigInteger bigIntegerFromBytes(final byte[] bytes) {
		return new BigInteger(1, bytes);
	}

	/**
	 * Converts a BigInteger into a byte array ignoring the sign of the BigInteger, according to RFC2945 specification
	 *
	 * @param bigInteger BigInteger, must not be null, should not be negative
	 *
	 * @return byte array (leading byte is always != 0), empty array if BigInteger is zero.
	 */
	public static byte[] bigIntegerToBytes(final BigInteger bigInteger) {
		assert(bigInteger.signum() != -1); // NOSONAR
		byte[] bytes = bigInteger.toByteArray();
		if (bytes[0] == 0) {
			return Arrays.copyOfRange(bytes, 1, bytes.length);
		}
		return bytes;
	}

	/**
	 * Prevents instantiation.
	 */
	private BigIntegerUtils() {
	
		// do nothing
	}
}
