/*
 * Copyright 2011-2021 Connect2id Ltd. and others
 * Copyright 2021 by DTV-Verkehrsconsult, Aachen
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.sys.funclib.srp6;


import java.math.BigInteger;


/**
 * Immutable snapshot of the SRP-6a client session variables to be used in a
 * {@link ClientEvidenceRoutine}.
 *
 * @author Vladimir Dzhuvinov
 */
public class SRP6ClientEvidenceContext {


	/**
	 * The user identity 'I'.
	 */
	public final String userID;
	
	
	/**
	 * The salt 's' used to compute the password key 'x' (and hence the
	 * verifier 'v').
	 */
	public final BigInteger s;
	
	
	/**
	 * The public client value 'A'.
	 */
	public final BigInteger A;
	
	
	/**
	 * The public server value 'B'.
	 */
	public final BigInteger B;
	
	
	/**
	 * The session key 'S'.
	 */
	public final BigInteger S;
	
	
	/**
	 * Creates a new immutable snapshot of SRP-6a client session variables.
	 *
	 * @param userID The user identity 'I'.
	 * @param s      The salt 's' used to compute the password key 'x'.
	 * @param A      The public client value 'A'.
	 * @param B      The public server value 'B'.
	 * @param S      The session key 'S'.
	 */
	public SRP6ClientEvidenceContext(final String userID,
	                                 final BigInteger s,
					 final BigInteger A,
					 final BigInteger B,
					 final BigInteger S) {
					    
		this.userID = userID;
		this.s = s;
		this.A = A;
		this.B = B;
		this.S = S;
	}
}
