/*
 * Copyright 2011-2021 Connect2id Ltd. and others
 * Copyright 2021 by DTV-Verkehrsconsult, Aachen
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.sys.funclib.srp6;


import java.math.BigInteger;


/**
 * Immutable snapshot of the SRP-6a client session variables to be used in a
 * {@link URoutine}.
 *
 * @author Simon Massey
 */
public class URoutineContext {


	/**
	 * The public client value 'A'.
	 */
	public final BigInteger A;


	/**
	 * The public server value 'B'.
	 */
	public final BigInteger B;


	/**
	 * Creates a new immutable snapshot of SRP-6a client session variables
	 * to be used in a {@link URoutine}.
	 *
	 * @param A The public client value 'A'.
	 * @param B The public server value 'B'.
	 */
	public URoutineContext(final BigInteger A, final BigInteger B) {

		this.A = A;
		this.B = B;
	}
}
