/*
 * Copyright 2011-2021 Connect2id Ltd. and others
 * Copyright 2021 by DTV-Verkehrsconsult, Aachen
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
/**
 * Secure Remote Password (SRP-6a) protocol implementation.
 *
 * <p>Features:
 *
 * <ul>
 *     <li>Convenient client and server-side session classes, with tracking of 
 *         the current authentication state.
 *     <li>Convenient verifier 'v' generator.
 *     <li>Allows selection of preferred 'N' and 'g' crypto parameters, hash 
 *         function 'H' and session timeouts.
 *     <li>Includes a set of pre-computed safe primes 'N' of various bitsizes
 *         (256-bit, 512-bit, etc.)
 *     <li>Interfaces to allow definition of custom routines for the password 
 *         key 'x', the server evidence message 'M1' and the client evidence 
 *         message 'M2'.
 *     <li>No external package dependencies.
 * </ul>
 *
 * <p>The routines for computing the various SRP-6a variables and messages are 
 * described in {@link de.bsvrz.sys.funclib.srp6.SRP6Routines}.
 *
 * <p>This product uses the 'Secure Remote Password' cryptographic 
 * authentication system developed by Tom Wu (tjw@CS.Stanford.EDU).
 */
package de.bsvrz.sys.funclib.srp6;
