/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.InQueuesMgr;
import de.bsvrz.ars.ars.mgmt.SimVarParamExtracter;
import de.bsvrz.ars.ars.mgmt.datatree.DataIdentNode;
import de.bsvrz.ars.ars.mgmt.datatree.DataIdentTree;
import de.bsvrz.ars.ars.mgmt.simulation.SimulationResultData;
import de.bsvrz.ars.ars.mgmt.tasks.QueueTask;
import de.bsvrz.ars.ars.persistence.CacheManager;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.util.SignalingQueue;
import de.bsvrz.ars.ars.persistence.writer.CloseContainerObject;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.dataIdentificationSettings.DataIdentification;
import de.bsvrz.sys.funclib.dataIdentificationSettings.EndOfSettingsListener;
import de.bsvrz.sys.funclib.dataIdentificationSettings.SettingsManager;
import de.bsvrz.sys.funclib.dataIdentificationSettings.UpdateListener;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;

public class ArchivConfig
extends QueueTask<SubscrMarker> {
    private static final String ARS_PARAM_ATG_PID = "atg.archiv";
    private static final String ARS_PARAM_DELETE_ATG_PID = "atg.archivDatenEndg\u00fcltigL\u00f6schen";
    private static final String ARS_PARAM_ASP_PID = "asp.parameterSoll";
    private static final String DEFAULT_PARAMS_FILE = "ArchivsystemParameter.txt";
    private static final long PARAM_TIMEOUT = 10000L;
    private boolean paramsAvailable;
    private InQueuesMgr inQueuesMgr;
    private int totalDIDs;
    @Nullable
    private SettingsManager settingsMgr;
    private EndOfSettingsListener eofSettingsLstnr;
    private UpdateListener updateSettingsLstnr;
    @Nullable
    private FileOutputStream paramDumpStream;
    private boolean printParams;
    private boolean noAnswer;
    private boolean gotFirstPrintParam;
    private final List<EndOfParamListener> endOfParamListeners = new ArrayList<EndOfParamListener>();
    private boolean isReady;
    private SimParamTask simParamWorker;
    private PermanentDeleteReceiver _permanentDeleteReceiver;
    private SubscrMarker markerTmp = new SubscrMarker();

    public ArchivConfig(ArchiveManager aMgr) {
        super(aMgr, new SignalingQueue());
    }

    public void setSimConfigQueue(SignalingQueue<ResultData> queue) {
        this.simParamWorker = new SimParamTask(this.getArchMgr(), queue);
        this.simParamWorker.start();
    }

    private SettingsManager createSettingsMgr() {
        SettingsManager sMgr = new SettingsManager(this.getArchMgr().getDavCon(), new DataIdentification((SystemObject)this.getArchMgr().getArchiveObject(), this.getArchMgr().getDD(ARS_PARAM_ATG_PID, ARS_PARAM_ASP_PID)));
        this.updateSettingsLstnr = (did, oldD, newD) -> {
            SubscrMarker subscrMarker = this.markerTmp;
            try {
                ArchivConfig archivConfig = this;
                synchronized (archivConfig) {
                    while (this.paramsAvailable) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
                ++this.totalDIDs;
                if (this.printParams) {
                    this.printParam(this.paramDumpStream, String.valueOf(this.totalDIDs), did, newD);
                } else if (oldD == null && newD != null) {
                    this.prepareNewParam(subscrMarker, did, newD);
                } else if (oldD != null && newD == null) {
                    this.prepareUnparam(subscrMarker, did);
                } else if (oldD != null) {
                    this.prepareReparam(subscrMarker, did, newD);
                } else {
                    _debug.warning("Archivparametrierung: ungueltige Parameter (oldD==newD==null)");
                }
            }
            catch (Exception npe) {
                Debug.getLogger().warning("Fehler beim Auswerten der eingehenden Daten. Daten werden ignoriert! " + String.valueOf(did) + ", " + String.valueOf(oldD) + ", " + String.valueOf(newD), (Throwable)npe);
            }
        };
        sMgr.addUpdateListener(this.updateSettingsLstnr);
        this.eofSettingsLstnr = () -> {
            this.submit(this.markerTmp);
            this.markerTmp = new SubscrMarker();
        };
        sMgr.addEndOfSettingsListener(this.eofSettingsLstnr);
        return sMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void work(SubscrMarker step) throws InterruptedException {
        this.processParams(step);
        Object object = this.endOfParamListeners;
        synchronized (object) {
            for (EndOfParamListener eopl : this.endOfParamListeners) {
                eopl.gotParams();
            }
            this.endOfParamListeners.clear();
        }
        object = this;
        synchronized (object) {
            this.paramsAvailable = false;
            this.notifyAll();
        }
    }

    public long getPermanentDeleteTimeSeconds(DataIdentNode dataIdentNode) {
        PermanentDeleteReceiver permanentDeleteReceiver = this._permanentDeleteReceiver;
        if (permanentDeleteReceiver == null) {
            return -1L;
        }
        IdDataIdentification dataIdentification = dataIdentNode.getDataIdentification();
        long parameterizedTime = permanentDeleteReceiver.getParameterizedDeleteExtraTimeSeconds(dataIdentification);
        if (parameterizedTime > 0L) {
            return parameterizedTime;
        }
        if (this.isPermanentlyDeleted(dataIdentification)) {
            return permanentDeleteReceiver.getDeleteExtraTimeSecondsForUnresolvable();
        }
        return -1L;
    }

    private boolean isPermanentlyDeleted(IdDataIdentification dataIdentification) {
        return this.isPermanentlyDeleted(dataIdentification.getObjectId()) || this.isPermanentlyDeleted(dataIdentification.getAtgId()) || this.isPermanentlyDeleted(dataIdentification.getAspectId());
    }

    private boolean isPermanentlyDeleted(long objectId) {
        DataModel dataModel = this.getArchMgr().getDataModel();
        return dataModel != null && dataModel.getObject(objectId) == null;
    }

    @Override
    public void terminateTask() {
        super.terminateTask();
        if (this.simParamWorker != null) {
            this.simParamWorker.terminateTask();
        }
    }

    @Override
    public void join() throws InterruptedException {
        super.join();
        if (this.simParamWorker != null) {
            this.simParamWorker.join();
        }
    }

    private void processSimParams(ResultData rd) throws InterruptedException {
        if (rd instanceof SimulationResultData) {
            SimulationResultData ard = (SimulationResultData)rd;
            HashMap<DataIdentification, Data> settingsMap = new HashMap<DataIdentification, Data>();
            SimVarParamExtracter.extractSettings(ard, this.getArchMgr().getDataModel(), settingsMap, ard.getSimVar());
            int i = 0;
            SubscrMarker sm = new SubscrMarker();
            for (Map.Entry dataIdentificationDataEntry : settingsMap.entrySet()) {
                ++i;
                DataIdentification dataIdentification = (DataIdentification)dataIdentificationDataEntry.getKey();
                DataDescription dd = dataIdentification.getDataDescription();
                DataIdentNode din = this.getDidTree().get(dataIdentification);
                din.arsParamSetParams((Data)dataIdentificationDataEntry.getValue());
                din.setFirstDataAfterSubscription(ArchiveDataKind.ONLINE, true);
                din.setFirstDataAfterSubscription(ArchiveDataKind.ONLINE_DELAYED, true);
                if (din.arSParamIsQuittieren()) {
                    SystemObject so = dataIdentification.getObject();
                    AttributeGroup atg = dd.getAttributeGroup();
                    Aspect asp = dd.getAspect();
                    short simulationVariant = dd.getSimulationVariant();
                    CacheManager.getInstance().setCachingEnabled(so.getId(), atg.getId(), asp.getId(), simulationVariant, false);
                    this.subscrAck(so, atg, asp, simulationVariant, din, sm);
                }
                this.getArchMgr().getInQueuesMgr().subscribe(this.getArchMgr().getDavCon(), dataIdentification.getObject(), dd);
            }
            _debug.info("Anmeldungen fuer Simulationsvariante " + ard.getSimVar() + " abgeschlossen:" + Debug.NEWLINE + Util.leadBlank((long)i, (int)6) + " Datenidentifikationen angemeldet davon " + Util.leadBlank((long)sm.subscrFaults, (int)6) + " Fehler" + Debug.NEWLINE + Util.leadBlank((long)i, (int)6) + " Quittierungen angemeldet davon " + Util.leadBlank((long)sm.qSubscrFault, (int)6) + " Fehler");
            ard.doneSubscribing(true);
        }
    }

    private void processParams(SubscrMarker subscrMarker) throws InterruptedException {
        if (this.printParams) {
            if (this.paramDumpStream != null) {
                ArchivConfig.closeParamDumpStream(this.paramDumpStream);
            }
        } else {
            _debug.info("EndOfSettingsListener: Archivparametrierung f\u00fcr " + this.totalDIDs + " Datenidentifikationen erhalten. Starte An/Abmeldungen...");
            this.processSubscriptions(subscrMarker);
            if (!this.isReady) {
                this.getArchMgr().archiveIsReady();
                this.isReady = true;
            }
            subscrMarker.printStatistics();
            subscrMarker.reset();
            this.totalDIDs = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndOfParamListener createEndOfParamListener() {
        EndOfParamListener eopl = new EndOfParamListener();
        List<EndOfParamListener> list = this.endOfParamListeners;
        synchronized (list) {
            this.endOfParamListeners.add(eopl);
        }
        return eopl;
    }

    public void startSubscribeArchiveParams(InQueuesMgr iqMgr, DataIdentTree dTree) {
        this.printParams = false;
        this.inQueuesMgr = iqMgr;
        if (this.getDidTree() != dTree) {
            throw new AssertionError();
        }
        this.start();
        this.restartSubscribeArchiveParams();
    }

    public void restartSubscribeArchiveParams() {
        this.settingsMgr = this.createSettingsMgr();
        this.settingsMgr.start();
        DataDescription dataDescription = this.getArchMgr().getDD(ARS_PARAM_DELETE_ATG_PID, ARS_PARAM_ASP_PID);
        if (dataDescription.getAttributeGroup() == null) {
            _debug.warning("Endg\u00fcltiges L\u00f6schen deaktiviert, da atg.archivDatenEndg\u00fcltigL\u00f6schen nicht vorhanden ist.");
            return;
        }
        this._permanentDeleteReceiver = new PermanentDeleteReceiver(dataDescription);
        this.getArchMgr().getDavCon().subscribeReceiver((ClientReceiverInterface)this._permanentDeleteReceiver, (SystemObject)this.getArchMgr().getArchiveObject(), dataDescription, ReceiveOptions.normal(), ReceiverRole.receiver());
    }

    public void unsubscribeArchiveParams() {
        if (this.settingsMgr != null) {
            this.settingsMgr.removeEndOfSettingsListener(this.eofSettingsLstnr);
            this.settingsMgr.removeUpdateListener(this.updateSettingsLstnr);
            this.settingsMgr.stop();
            this.settingsMgr = null;
        }
        if (this._permanentDeleteReceiver != null) {
            this.getArchMgr().getDavCon().unsubscribeReceiver((ClientReceiverInterface)this._permanentDeleteReceiver, (SystemObject)this.getArchMgr().getArchiveObject(), this._permanentDeleteReceiver.getDataDescription());
        }
    }

    private void unsubscribeArchiveData(int simVar) {
        _debug.info("Start Abmeldung aller zu archivierenden Datenidentifikationen" + (String)(simVar < 0 ? "" : " der Simulationsvariante " + simVar));
        int numDID = 0;
        if (this.getDidTree() != null) {
            for (DataIdentNode din : this.getDidTree()) {
                IdDataIdentification id = din.getDataIdentification();
                if (simVar >= 0 && id.getSimVariant() != simVar || !din.isArSParameterized() || !din.arSParamIsArchivieren()) continue;
                SystemObject so = this.getArchMgr().getObj(id.getObjectId());
                DataDescription dd = new DataDescription(this.getArchMgr().getAtg(id.getAtgId()), this.getArchMgr().getAsp(id.getAspectId()), (short)id.getSimVariant());
                this.getArchMgr().getDavCon().unsubscribeReceiver((ClientReceiverInterface)this.inQueuesMgr.getArchiveDataReceiver(), so, dd);
                _debug.finest("Abmeldung fuer " + String.valueOf(so) + ", " + String.valueOf(dd) + " erfolgreich");
                ++numDID;
            }
        }
        _debug.info(numDID + " zu archivierende Datenidentifikationen" + (String)(simVar != -1 ? " fuer SimVar " + simVar : "") + " abgemeldet");
    }

    public void unsubscribeArchiveData() {
        this.unsubscribeArchiveData(-1);
    }

    public void unsubscribeSimVarData(int simVar) {
        this.unsubscribeArchiveData(simVar);
        this.unsubscribeArchiveDataAck(simVar);
        for (DataIdentNode dataIdentNode : this.getDidTree()) {
            if (dataIdentNode.getDataIdentification().getSimVariant() != simVar) continue;
            dataIdentNode.arsParamSetParams(null);
        }
    }

    private void unsubscribeArchiveDataAck(int simVar) {
        _debug.info("Start Abmeldung aller Quittierungsaspekte" + (String)(simVar < 0 ? "" : " der Simulationsvariante " + simVar));
        ClientDavInterface davCon = this.getArchMgr().getDavCon();
        int numQ = 0;
        for (DataIdentNode din : this.getDidTree()) {
            IdDataIdentification id = din.getDataIdentification();
            if (simVar >= 0 && id.getSimVariant() != simVar || !din.isArSParameterized() || !din.arSParamIsQuittierenValid()) continue;
            SystemObject so = davCon.getDataModel().getObject(id.getObjectId());
            AttributeGroup atg = (AttributeGroup)davCon.getDataModel().getObject(id.getAtgId());
            Aspect asp = (Aspect)davCon.getDataModel().getObject(din.arSParamGetQuittieren());
            CacheManager.getInstance().setCachingEnabled(id.getObjectId(), id.getAtgId(), id.getAspectId(), id.getSimVariant(), true);
            davCon.unsubscribeSender((ClientSenderInterface)this.inQueuesMgr.getDataAckSender(), so, new DataDescription(atg, asp, (short)id.getSimVariant()));
            ++numQ;
        }
        _debug.info(numQ + " Quittierungsaspekte" + (String)(simVar != -1 ? " fuer SimVar " + simVar : "") + " abgemeldet");
    }

    public void unsubscribeArchiveDataAck() {
        this.unsubscribeArchiveDataAck(-1);
    }

    public void printArchiveParams(File dumpFile) throws TimeoutException, InterruptedException {
        this.printParams = true;
        this.paramDumpStream = dumpFile == null ? null : this.createParamDumpStream(dumpFile);
        this.noAnswer = false;
        this.gotFirstPrintParam = false;
        EndOfParamListener eopl = this.createEndOfParamListener();
        Thread watchdog = new Thread(() -> {
            try {
                Thread.sleep(10000L);
                if (!this.gotFirstPrintParam) {
                    this.noAnswer = true;
                    eopl.gotParams();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        watchdog.start();
        this.start();
        this.settingsMgr = this.createSettingsMgr();
        this.settingsMgr.start();
        eopl.waitForParams();
        watchdog.interrupt();
        if (this.noAnswer) {
            throw new TimeoutException("Kein Parameter-Datensatz nach 10 Sekunden erhalten.");
        }
    }

    @Nullable
    private FileOutputStream createParamDumpStream(File dumpFile) {
        try {
            if (dumpFile.isDirectory()) {
                dumpFile = new File(dumpFile, DEFAULT_PARAMS_FILE);
            }
            if (dumpFile.exists()) {
                this.getArchMgr().quitError("Ausgabedatei '" + dumpFile.getAbsolutePath() + "' f\u00fcr die Archivparametrierung existiert bereits.");
            }
            if (!dumpFile.createNewFile()) {
                this.getArchMgr().quitError("Ausgabedatei '" + dumpFile.getAbsolutePath() + "' f\u00fcr die Archivparametrierung konnte nicht angelegt werden.");
            }
            if (!dumpFile.canWrite()) {
                this.getArchMgr().quitError("Ausgabedatei '" + dumpFile.getAbsolutePath() + "' kann nicht geschrieben werden.");
            }
            return new FileOutputStream(dumpFile);
        }
        catch (IOException e) {
            this.getArchMgr().quitError("Ausgabedatei '" + dumpFile.getAbsolutePath() + "' f\u00fcr die Archivparametrierung konnte nicht angelegt werden: " + e.getMessage());
            return null;
        }
    }

    private static void closeParamDumpStream(FileOutputStream ds) {
        try {
            ds.close();
        }
        catch (IOException e) {
            _debug.error("Fehler beim Schreiben der Ausgabedatei f\u00fcr die Archivparametrierung" + e.getMessage());
        }
    }

    private void unsubscrAck(SystemObject so, AttributeGroup atg, int sv, long qAspId, SubscrMarker subscrMarker) {
        ++subscrMarker.qUnsubscrTotal;
        try {
            Aspect qAsp = this.getArchMgr().getAsp(qAspId);
            this.getArchMgr().getDavCon().unsubscribeSender((ClientSenderInterface)this.inQueuesMgr.getDataAckSender(), so, new DataDescription(atg, qAsp, (short)sv));
        }
        catch (IllegalArgumentException e) {
            _debug.error("Sendeabmeldung eines illegalen Quittierungsaspektes: " + e.getMessage());
        }
    }

    private void subscrAck(SystemObject so, AttributeGroup atg, Aspect asp, int sv, DataIdentNode din, SubscrMarker sm) {
        long qAspId = din.arSParamGetQuittieren();
        if (sm != null) {
            ++sm.qSubscrTotal;
        }
        try {
            if (asp.getId() == qAspId) {
                throw new IllegalStateException("AspektID==QuittungsaspektID");
            }
            Aspect qAsp = this.getArchMgr().getAsp(qAspId);
            this.getArchMgr().getDavCon().subscribeSender((ClientSenderInterface)this.getArchMgr().getInQueuesMgr().getDataAckSender(), so, new DataDescription(atg, qAsp, (short)sv), SenderRole.source());
            din.arSParamMarkQuittierenInvalid(false);
            return;
        }
        catch (Exception e) {
            Exception ex = e;
            if (sm != null) {
                ++sm.qSubscrFault;
            }
            din.arSParamMarkQuittierenInvalid(true);
            _debug.fine("Sendeanmeldung fuer Quittierungsaspekt 'id=" + qAspId + "' fuer " + String.valueOf(so) + ", " + String.valueOf(atg) + "' fehlgeschlagen: " + ex.getMessage());
            return;
        }
    }

    private void processSubscriptions(SubscrMarker subscrMarker) throws InterruptedException {
        ClientDavInterface davCon = this.getArchMgr().getDavCon();
        long i = 0L;
        long t = Util.startTimer();
        for (DataIdentNode din : this.getDidTree()) {
            if (this.shouldTerminate()) {
                return;
            }
            IdDataIdentification id = din.getDataIdentification();
            SubscrMarker.SubscrInfo si = subscrMarker.getSubscrInfo(din);
            if (si != null) {
                ++i;
                SystemObject so = this.getArchMgr().getObj(id.getObjectId());
                AttributeGroup atg = this.getArchMgr().getAtg(id.getAtgId());
                Aspect asp = this.getArchMgr().getAsp(id.getAspectId());
                DataDescription dd = new DataDescription(atg, asp, (short)id.getSimVariant());
                switch (si.kind) {
                    case 1: 
                    case 4: {
                        if (si.kind == 4) {
                            this.inQueuesMgr.insertCloseContainer(new CloseContainerObject(new IdDataIdentification(so, dd)));
                        }
                        try {
                            din.setFirstDataAfterSubscription(ArchiveDataKind.ONLINE, true);
                            din.setFirstDataAfterSubscription(ArchiveDataKind.ONLINE_DELAYED, true);
                            boolean subscribed = this.getArchMgr().getInQueuesMgr().subscribe(davCon, so, dd);
                            if (subscribed) {
                                if (din.arSParamIsQuittieren()) {
                                    CacheManager.getInstance().setCachingEnabled(so.getId(), atg.getId(), asp.getId(), id.getSimVariant(), false);
                                    this.subscrAck(so, atg, asp, id.getSimVariant(), din, subscrMarker);
                                    break;
                                }
                                din.arSParamMarkQuittierenInvalid(false);
                                break;
                            }
                            ++subscrMarker.subscrFaults;
                        }
                        catch (IllegalArgumentException e) {
                            ++subscrMarker.subscrFaults;
                            _debug.error(i + ".: Empfangsanmeldung fuer " + String.valueOf(so) + ", " + String.valueOf(dd) + " fehlgeschlagen: " + e.getMessage());
                        }
                        break;
                    }
                    case 3: 
                    case 5: {
                        davCon.unsubscribeReceiver((ClientReceiverInterface)this.inQueuesMgr.getArchiveDataReceiver(), so, dd);
                        this.inQueuesMgr.insertCloseContainer(new CloseContainerObject(new IdDataIdentification(so, dd)));
                        if (si.kind == 3 && din.arSParamIsQuittierenValid()) {
                            CacheManager.getInstance().setCachingEnabled(so.getId(), atg.getId(), asp.getId(), id.getSimVariant(), true);
                            long qAsp = din.arSParamGetQuittieren();
                            this.unsubscrAck(so, atg, id.getSimVariant(), qAsp, subscrMarker);
                        } else if (si.kind == 5 && si.hasOldAspect()) {
                            CacheManager.getInstance().setCachingEnabled(so.getId(), atg.getId(), asp.getId(), id.getSimVariant(), true);
                            long qAsp = si.oldQAspectId;
                            this.unsubscrAck(so, atg, id.getSimVariant(), qAsp, subscrMarker);
                        }
                        din.arSParamMarkQuittierenInvalid(true);
                        if (si.kind != 3) break;
                        din.arsParamSetParams(null);
                        break;
                    }
                    case 6: {
                        CacheManager.getInstance().setCachingEnabled(so.getId(), atg.getId(), asp.getId(), id.getSimVariant(), true);
                        if (si.hasOldAspect()) {
                            this.unsubscrAck(so, atg, id.getSimVariant(), si.oldQAspectId, subscrMarker);
                        }
                        if (din.arSParamIsArchivieren()) {
                            din.arSParamMarkQuittierenInvalid(false);
                        }
                        if (!din.arSParamIsArchivieren() || !din.arSParamIsQuittieren()) break;
                        CacheManager.getInstance().setCachingEnabled(so.getId(), atg.getId(), asp.getId(), id.getSimVariant(), false);
                        this.subscrAck(so, atg, asp, id.getSimVariant(), din, subscrMarker);
                        break;
                    }
                    case 2: {
                        din.arSParamMarkQuittierenInvalid(true);
                    }
                }
                continue;
            }
            din.arsParamSetParams(null);
        }
        _debug.info(i + " An/Abmeldungen durchgef\u00fchrt in " + Util.stopTimer((long)t));
    }

    private void prepareReparam(SubscrMarker subscrMarker, DataIdentification did, Data newD) {
        DataIdentNode din = this.getDidTree().get(did);
        boolean archivieren = ArchivConfig.getBool(newD, "Archivieren");
        if (!din.arSParamIsArchivieren() && archivieren) {
            subscrMarker.reParamArch(din);
        } else if (din.arSParamIsArchivieren() && !archivieren) {
            if (din.arSParamIsQuittierenValid()) {
                subscrMarker.reParamNoArch(din, din.arSParamGetQuittieren());
            } else {
                subscrMarker.reParamNoArch(din);
            }
        } else if (din.arSParamIsQuittierenValid() && din.arSParamIsQuittieren()) {
            subscrMarker.reParam(din, din.arSParamGetQuittieren());
        } else {
            subscrMarker.reParam(din);
        }
        din.arsParamSetParams(newD);
    }

    private void prepareNewParam(SubscrMarker subscrMarker, DataIdentification did, Data newD) {
        DataIdentNode din = this.getDidTree().get(did);
        din.arsParamSetParams(newD);
        if (din.arSParamIsArchivieren()) {
            subscrMarker.newParamArch(din);
        } else {
            subscrMarker.newParamNoArch(din);
        }
    }

    private void prepareUnparam(SubscrMarker subscrMarker, DataIdentification did) {
        subscrMarker.unParam(this.getDidTree().get(did));
    }

    private void printParam(@Nullable OutputStream dumpStream, String separatorLine, DataIdentification did, Data data) {
        this.gotFirstPrintParam = true;
        StringBuilder sb = new StringBuilder();
        DataDescription dd = did.getDataDescription();
        sb.append(separatorLine + "\nobj   " + did.getObject().getPid() + " (id=" + did.getObject().getId() + ") '" + did.getObject().getName() + "'\natg   " + dd.getAttributeGroup().getPid() + " (" + dd.getAttributeGroup().getId() + ") '" + dd.getAttributeGroup().getName() + "'\nasp   ");
        sb.append(dd.getAspect().getPid() + " (" + dd.getAspect().getId() + ") '" + dd.getAspect().getName() + "'\nsv    " + dd.getSimulationVariant() + "\n");
        if (data != null) {
            sb.append("einst archiv.: " + (ArchivConfig.getBool(data, "Archivieren") ? "ja" : "nein"));
            sb.append(" / sich.: " + (ArchivConfig.getBool(data, "Sichern") ? "ja" : "nein"));
            sb.append(" / quitt.: " + (data.getArray("Quittieren").getLength() > 0 ? data.getArray("Quittieren").getItem(0).asReferenceValue().getValueText() : "---"));
            sb.append(" / vorh.: " + data.getTimeValue("Vorhalten").getSeconds());
            int nachf = data.getArray("Nachfordern").getLength();
            if (nachf == 0) {
                sb.append(" / nachf.: ---");
            } else {
                sb.append("\n      nachf.:\n");
                for (int j = 0; j < nachf; ++j) {
                    sb.append("      " + data.getArray("Nachfordern").getItem(j).asTextValue().getValueText());
                }
            }
            sb.append("\n");
        } else {
            sb.append("   ## Fehler: Data==null");
        }
        if (dumpStream != null) {
            try {
                dumpStream.write(sb.toString().getBytes(Charset.defaultCharset()));
                dumpStream.flush();
            }
            catch (IOException e) {
                _debug.error("Fehler beim Schreiben der Ausgabedatei f\u00fcr die Archivparametrierung: " + e.getMessage());
            }
        } else {
            System.out.print(sb);
        }
    }

    private static boolean getBool(Data data, String key) {
        return data.getUnscaledValue(key).intValue() > 0;
    }

    protected static class SubscrMarker {
        private static final SubscrInfo SI_NEW_PARAM_ARCH = new SubscrInfo(1);
        private static final SubscrInfo SI_NEW_PARAM_NOARCH = new SubscrInfo(2);
        private static final SubscrInfo SI_UN_PARAM = new SubscrInfo(3);
        private static final SubscrInfo SI_RE_PARAM_ARCH = new SubscrInfo(4);
        private static final SubscrInfo SI_RE_PARAM_NOARCH = new SubscrInfo(5);
        private static final SubscrInfo SI_RE_PARAM_PARAM = new SubscrInfo(6);
        private final Map<DataIdentNode, SubscrInfo> marker = new HashMap<DataIdentNode, SubscrInfo>();
        public int subscrFaults;
        public int unsubscrFaults;
        public int qSubscrTotal;
        public int qUnsubscrTotal;
        public int qUnsubscrFault;
        public int qSubscrFault;

        protected SubscrMarker() {
        }

        public void newParamArch(DataIdentNode din) {
            this.marker.put(din, SI_NEW_PARAM_ARCH);
        }

        public void newParamNoArch(DataIdentNode din) {
            this.marker.put(din, SI_NEW_PARAM_NOARCH);
        }

        public void unParam(DataIdentNode din) {
            this.marker.put(din, SI_UN_PARAM);
        }

        public void reParamArch(DataIdentNode din) {
            this.marker.put(din, SI_RE_PARAM_ARCH);
        }

        public void reParamNoArch(DataIdentNode din, long oldQAspectId) {
            SubscrInfo sc = SI_RE_PARAM_NOARCH.copy();
            sc.oldQAspectId = oldQAspectId;
            this.marker.put(din, sc);
        }

        public void reParamNoArch(DataIdentNode din) {
            this.marker.put(din, SI_RE_PARAM_NOARCH);
        }

        public void reParam(DataIdentNode din, long oldQAspectId) {
            SubscrInfo sc = SI_RE_PARAM_PARAM.copy();
            sc.oldQAspectId = oldQAspectId;
            this.marker.put(din, sc);
        }

        public void reParam(DataIdentNode din) {
            this.marker.put(din, SI_RE_PARAM_PARAM);
        }

        public SubscrInfo getSubscrInfo(DataIdentNode din) {
            return this.marker.get(din);
        }

        public void reset() {
            this.subscrFaults = 0;
            this.unsubscrFaults = 0;
            this.qSubscrTotal = 0;
            this.qUnsubscrTotal = 0;
            this.qUnsubscrFault = 0;
            this.qSubscrFault = 0;
            this.marker.clear();
        }

        private void printStatistics() {
            String text = this.toString();
            if (text.equals("[]")) {
                return;
            }
            _debug.info("An/Abmeldungen abgeschlossen:\n  " + text);
        }

        public String toString() {
            int newparam_arch = 0;
            int newparam_noarch = 0;
            int reparam_param = 0;
            int reparam_subscr = 0;
            int reparam_unsubscr = 0;
            int unparam = 0;
            int closeCont = 0;
            if (this.marker.isEmpty()) {
                return "[]";
            }
            for (SubscrInfo si : this.marker.values()) {
                if (si.kind == 1) {
                    ++newparam_arch;
                    continue;
                }
                if (si.kind == 2) {
                    ++newparam_noarch;
                    continue;
                }
                if (si.kind == 3) {
                    ++unparam;
                    ++closeCont;
                    continue;
                }
                if (si.kind == 4) {
                    ++reparam_subscr;
                    ++closeCont;
                    continue;
                }
                if (si.kind == 5) {
                    ++reparam_unsubscr;
                    ++closeCont;
                    continue;
                }
                if (si.kind != 6) continue;
                ++reparam_param;
            }
            return Util.leadBlank((long)(newparam_arch + newparam_noarch), (int)6) + " Zugaenge (" + newparam_arch + " arch / " + newparam_noarch + " noarch), " + unparam + " Abgaenge, " + (reparam_param + reparam_unsubscr + reparam_subscr) + " Aenderungen (" + reparam_subscr + "->arch / " + reparam_unsubscr + "->noarch / " + reparam_param + " andere), insgesamt " + this.marker.size() + "\n  " + Util.leadBlank((long)closeCont, (int)6) + " Datenidentifikationen abzuschliessen\n  " + Util.leadBlank((long)this.subscrFaults, (int)6) + " Fehler bei Anmeldungen von Datenidentifikationen\n  " + Util.leadBlank((long)this.unsubscrFaults, (int)6) + " Fehler bei Abmeldungen von Datenidentifikationen\n  " + Util.leadBlank((long)this.qSubscrTotal, (int)6) + " Anmeldungen von Quittierungen, davon " + this.qSubscrFault + " Fehler\n  " + Util.leadBlank((long)this.qUnsubscrTotal, (int)6) + " Abmeldungen von Quittierungen, davon " + this.qUnsubscrFault + " Fehler";
        }

        protected static final class SubscrInfo {
            public static final int NEW_PARAM_ARCH = 1;
            public static final int NEW_PARAM_NOARCH = 2;
            public static final int UN_PARAM = 3;
            public static final int RE_PARAM_ARCH = 4;
            public static final int RE_PARAM_NOARCH = 5;
            public static final int RE_PARAM_PARAM = 6;
            public final int kind;
            public long oldQAspectId = -1L;

            public SubscrInfo(int kind) {
                this.kind = kind;
            }

            public SubscrInfo(int kind, long oldQAspectId) {
                this.kind = kind;
                this.oldQAspectId = oldQAspectId;
            }

            public boolean hasOldAspect() {
                return this.oldQAspectId != -1L;
            }

            public SubscrInfo copy() {
                return new SubscrInfo(this.kind, this.oldQAspectId);
            }
        }
    }

    private class SimParamTask
    extends QueueTask<ResultData> {
        protected SimParamTask(ArchiveManager archiveMgr, SignalingQueue<ResultData> queue) {
            super(archiveMgr, queue);
        }

        @Override
        protected void work(ResultData step) throws InterruptedException {
            ArchivConfig.this.processSimParams(step);
        }
    }

    public static class EndOfParamListener {
        public boolean gotParams;

        private synchronized void gotParams() {
            this.gotParams = true;
            this.notifyAll();
        }

        public synchronized void waitForParams() throws InterruptedException {
            while (!this.gotParams) {
                this.wait();
            }
        }
    }

    private class PermanentDeleteReceiver
    implements ClientReceiverInterface {
        private final DataDescription _dataDescription;
        private List<ParameterizedBlock> _parameterizedBlocks = ImmutableList.of();
        private long _deleteExtraTimeSecondsForUnresolvable = -1L;

        public PermanentDeleteReceiver(DataDescription dataDescription) {
            this._dataDescription = dataDescription;
        }

        public DataDescription getDataDescription() {
            return this._dataDescription;
        }

        public void update(ResultData[] results) {
            for (ResultData result : results) {
                Data data = result.getData();
                if (data == null) continue;
                ArchivConfig.this.getArchMgr().getTaskScheduler().setDeletePermanentlyInterval(data.getTextValue("L\u00f6schintervall").getText(), "Ja".equals(data.getTextValue("Aktiv").getText()));
                this._parameterizedBlocks = this.parseParameterizedBlocks(data);
                this._deleteExtraTimeSecondsForUnresolvable = data.getTimeValue("VorhaltezeitEndg\u00fcltigGel\u00f6schteObjekte").getSeconds();
            }
        }

        private List<ParameterizedBlock> parseParameterizedBlocks(Data data) {
            ArrayList<ParameterizedBlock> result = new ArrayList<ParameterizedBlock>();
            for (Data datum : data.getItem("ParameterSatz")) {
                Set<String> areaPids = this.getPids(datum.getReferenceArray("Bereich"));
                ArrayList<ParameterizedBlockTuple> blocks = new ArrayList<ParameterizedBlockTuple>();
                Data dataSpecificationArray = datum.getItem("DatenSpezifikation");
                for (Data dataSpecBlock : dataSpecificationArray) {
                    blocks.add(this.parseParameterizedBlockTuple(dataSpecBlock));
                }
                long timeSeconds = datum.getTimeValue("Zus\u00e4tzlicheVorhaltezeit").getSeconds();
                result.add(new ParameterizedBlock(areaPids, blocks, timeSeconds));
            }
            return result;
        }

        private ParameterizedBlockTuple parseParameterizedBlockTuple(Data datum) {
            Set<String> objectPids = this.getPids(datum.getReferenceArray("Objekt"));
            Set<String> attributeGroupPids = this.getPids(datum.getReferenceArray("AttributGruppe"));
            Set<String> aspectPids = this.getPids(datum.getReferenceArray("Aspekt"));
            int simVar = datum.getUnscaledValue("SimulationsVariante").intValue();
            return new ParameterizedBlockTuple(objectPids, attributeGroupPids, aspectPids, simVar);
        }

        private Set<String> getPids(Data.ReferenceArray array) {
            return (Set)Arrays.stream(array.getSystemObjectArray()).map(it -> it != null ? it.getPidOrId() : "").collect(ImmutableSet.toImmutableSet());
        }

        public long getParameterizedDeleteExtraTimeSeconds(IdDataIdentification dataIdentification) {
            DataModel dataModel = ArchivConfig.this.getArchMgr().getDataModel();
            if (dataModel == null) {
                return -1L;
            }
            SystemObject object = dataModel.getObject(dataIdentification.getObjectId());
            SystemObject attributeGroup = dataModel.getObject(dataIdentification.getAtgId());
            SystemObject aspect = dataModel.getObject(dataIdentification.getAspectId());
            if (object == null || attributeGroup == null || aspect == null) {
                return -1L;
            }
            String objectPid = object.getPidOrId();
            String attributeGroupPid = attributeGroup.getPidOrId();
            String aspectPid = aspect.getPidOrId();
            String areaPid = object.getConfigurationArea().getPidOrId();
            long result = -1L;
            for (ParameterizedBlock parameterizedBlock : this._parameterizedBlocks) {
                if (!parameterizedBlock.matches(areaPid, objectPid, attributeGroupPid, aspectPid, dataIdentification.getSimVariant())) continue;
                result = parameterizedBlock.getDeleteTimeSeconds();
            }
            return result;
        }

        public long getDeleteExtraTimeSecondsForUnresolvable() {
            if (this._deleteExtraTimeSecondsForUnresolvable < 1L) {
                return -1L;
            }
            return this._deleteExtraTimeSecondsForUnresolvable;
        }

        private boolean matchesSetWithWildcard(Set<String> set, String item) {
            return set.isEmpty() || set.contains(item);
        }

        private class ParameterizedBlockTuple {
            private final Set<String> _objectPids;
            private final Set<String> _attributeGroupPids;
            private final Set<String> _aspectPids;
            private final int _simVar;

            public ParameterizedBlockTuple(Set<String> objectPids, Set<String> attributeGroupPids, Set<String> aspectPids, int simVar) {
                this._objectPids = objectPids;
                this._attributeGroupPids = attributeGroupPids;
                this._aspectPids = aspectPids;
                this._simVar = simVar;
            }

            public boolean matches(String objectPid, String attributeGroupPid, String aspectPid, int simVariant) {
                return PermanentDeleteReceiver.this.matchesSetWithWildcard(this._objectPids, objectPid) && PermanentDeleteReceiver.this.matchesSetWithWildcard(this._attributeGroupPids, attributeGroupPid) && PermanentDeleteReceiver.this.matchesSetWithWildcard(this._aspectPids, aspectPid) && simVariant == this._simVar;
            }

            public String toString() {
                return "ParameterizedBlockTuple{_objectPids=" + String.valueOf(this._objectPids) + ", _attributeGroupPids=" + String.valueOf(this._attributeGroupPids) + ", _aspectPids=" + String.valueOf(this._aspectPids) + ", _simVar=" + this._simVar + "}";
            }
        }

        private class ParameterizedBlock {
            private final Set<String> _areaPids;
            private final List<ParameterizedBlockTuple> _blocks;
            private final long _timeSeconds;

            public ParameterizedBlock(Set<String> areaPids, List<ParameterizedBlockTuple> blocks, long timeSeconds) {
                this._areaPids = areaPids;
                this._blocks = blocks;
                this._timeSeconds = timeSeconds;
            }

            public boolean matches(String areaPid, String objectPid, String attributeGroupPid, String aspectPid, int simVariant) {
                return PermanentDeleteReceiver.this.matchesSetWithWildcard(this._areaPids, areaPid) && this._blocks.stream().anyMatch(it -> it.matches(objectPid, attributeGroupPid, aspectPid, simVariant));
            }

            public long getDeleteTimeSeconds() {
                return this._timeSeconds;
            }

            public String toString() {
                return "ParameterizedBlock{_areaPids=" + String.valueOf(this._areaPids) + ", _blocks=" + String.valueOf(this._blocks) + ", _timeSeconds=" + this._timeSeconds + "}";
            }
        }
    }
}

