/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.LongTermTaskStatePublisher;
import de.bsvrz.ars.ars.mgmt.tasks.base.Task;
import de.bsvrz.ars.ars.mgmt.tasks.base.TaskManager;
import de.bsvrz.ars.ars.mgmt.tasks.base.TaskState;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.LinkedHashSet;
import java.util.List;

public class ArchiveLongTermTaskStatePublisher
implements LongTermTaskStatePublisher {
    private static final long ALL_TASK_UPDATE_INTERVAL = 60000L;
    private static final long TASK_UPDATE_INTERVAL = 10000L;
    private final List<ArchiveLongTermTask> _tasks = new ArrayList<ArchiveLongTermTask>();
    private ClientDavInterface _davConnection;
    private long _nextAllTaskUpdateTime;
    private boolean _enableDataSource;
    private final Debug _debug = Debug.getLogger();
    private static final String NEWLINE = System.getProperty("line.separator");
    private final ArchiveManager _archMgr;
    private final String _minorChangeHeaderText;
    private final String _majorChangeHeaderText;
    private AttributeGroup _atg;
    private ConfigurationObject _archiveObject;
    private DataDescription _dataDescription;

    public ArchiveLongTermTaskStatePublisher(ArchiveManager archMgr, String minorChangeHeaderText, String majorChangeHeaderText) {
        this._archMgr = archMgr;
        this._minorChangeHeaderText = minorChangeHeaderText;
        this._majorChangeHeaderText = majorChangeHeaderText;
        this._nextAllTaskUpdateTime = System.currentTimeMillis();
    }

    @Override
    public void setDavConnection(ClientDavInterface davConnection) {
        this._davConnection = davConnection;
        try {
            DataModel dataModel = davConnection.getDataModel();
            this._atg = dataModel.getAttributeGroup("atg.hintergrundTaskZust\u00e4nde");
            Aspect asp = dataModel.getAspect("asp.archivSystem");
            if (this._atg == null || asp == null) {
                this._debug.info("Kann Taskzust\u00e4nde nicht ver\u00f6ffentlichen, ben\u00f6tigte Attributgruppe und/oder Aspekt sind nicht im Datenmodell vorhanden. Es wird mindestens Version 23 von kb.systemModellGlobal.config ben\u00f6tigt.");
                return;
            }
            this._archiveObject = this._archMgr.getArchiveObject();
            this._dataDescription = new DataDescription(this._atg, asp);
            davConnection.subscribeSender((ClientSenderInterface)new ClientSender(), (SystemObject)this._archiveObject, this._dataDescription, SenderRole.source());
        }
        catch (OneSubscriptionPerSendData oneSubscriptionPerSendData) {
            this._debug.warning("Es gibt bereits ein Objekt, dass Taskzust\u00e4nde ver\u00f6ffentlicht", (Throwable)oneSubscriptionPerSendData);
        }
        catch (Exception e) {
            this._debug.warning("Fehler beim Anmelden der Ver\u00f6ffentlichung der Taskzust\u00e4nde", (Throwable)e);
        }
    }

    private Data createDataObject() {
        Data data = this._davConnection.createData(this._atg);
        Data.Array array = data.getItem("HintergrundTaskZust\u00e4nde").asArray();
        int i = 0;
        LinkedHashSet<ArchiveLongTermTask> allTasks = new LinkedHashSet<ArchiveLongTermTask>(this._tasks);
        allTasks.addAll(TaskManager.getActiveTasks());
        array.setLength(allTasks.size());
        for (Task task : allTasks) {
            this.insertData(task, array.getItem(i++));
        }
        return data;
    }

    private void insertData(Task task, Data item) {
        item.getItem("TaskName").asTextValue().setText(task.getName());
        item.getItem("TaskZustand").asTextValue().setText(task.getState().getStateName());
        item.getItem("TaskFortschrittsBeschreibung").asTextValue().setText(task.getProgressText());
        item.getItem("TaskFortschritt").asUnscaledValue().set(task.getProgress());
        item.getItem("TaskFortschrittMaximum").asUnscaledValue().set(task.getMaximumProgress());
        item.getItem("TaskFortschrittErgebnis").asUnscaledValue().set(task.getProgressResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task registerTask(String taskName) {
        ArchiveLongTermTaskStatePublisher archiveLongTermTaskStatePublisher = this;
        synchronized (archiveLongTermTaskStatePublisher) {
            ArchiveLongTermTask longTermTask = new ArchiveLongTermTask(taskName);
            this._tasks.add(longTermTask);
            return longTermTask;
        }
    }

    private void publishMajorChanges(long now) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._majorChangeHeaderText);
        stringBuilder.append(NEWLINE);
        for (ArchiveLongTermTask longTermTask : this._tasks) {
            longTermTask.appendTo(stringBuilder);
            stringBuilder.append(NEWLINE);
            longTermTask.publishedMinorChanges(now);
        }
        this._debug.info(stringBuilder.toString());
        if (this._enableDataSource) {
            try {
                Data data = this.createDataObject();
                this._davConnection.sendData(new ResultData((SystemObject)this._archiveObject, this._dataDescription, System.currentTimeMillis(), data));
            }
            catch (Exception e) {
                this._debug.warning("Fehler beim Senden der Taskzust\u00e4nde", (Throwable)e);
            }
        }
        this._nextAllTaskUpdateTime = now + 60000L;
    }

    private void notifyMinorChanges(long now) {
        if (now > this._nextAllTaskUpdateTime) {
            this.publishMajorChanges(now);
        }
    }

    private class ClientSender
    implements ClientSenderInterface {
        private ClientSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
            ArchiveLongTermTaskStatePublisher archiveLongTermTaskStatePublisher = ArchiveLongTermTaskStatePublisher.this;
            synchronized (archiveLongTermTaskStatePublisher) {
                if (object.equals((Object)ArchiveLongTermTaskStatePublisher.this._archiveObject) && dataDescription.equals((Object)ArchiveLongTermTaskStatePublisher.this._dataDescription)) {
                    boolean bl = ArchiveLongTermTaskStatePublisher.this._enableDataSource = state == 0;
                    if (ArchiveLongTermTaskStatePublisher.this._enableDataSource) {
                        try {
                            Data data = ArchiveLongTermTaskStatePublisher.this.createDataObject();
                            ArchiveLongTermTaskStatePublisher.this._davConnection.sendData(new ResultData((SystemObject)ArchiveLongTermTaskStatePublisher.this._archiveObject, ArchiveLongTermTaskStatePublisher.this._dataDescription, System.currentTimeMillis(), data));
                            ArchiveLongTermTaskStatePublisher.this._debug.info("Taskzust\u00e4nde werden \u00fcber Datenverteiler ver\u00f6ffentlicht");
                        }
                        catch (Exception e) {
                            ArchiveLongTermTaskStatePublisher.this._debug.warning("Fehler beim Senden der Taskzust\u00e4nde", (Throwable)e);
                        }
                    } else {
                        ArchiveLongTermTaskStatePublisher.this._debug.info("Ver\u00f6ffentlichung der Taskzust\u00e4nde gestoppt");
                    }
                }
            }
        }

        public boolean isRequestSupported(SystemObject object, DataDescription dataDescription) {
            return true;
        }
    }

    private class ArchiveLongTermTask
    implements Task {
        private volatile long _nextTaskUpdateTime;
        private final String _taskName;
        private volatile TaskState _taskState = TaskState.INIT;
        private volatile boolean _minorChanges;
        private volatile String _format = "";
        private volatile long _progress = -1L;
        private volatile long _maximumProgress = -1L;
        private volatile long _progressResult = -1L;

        public ArchiveLongTermTask(String taskName) {
            this._taskName = taskName;
            this._nextTaskUpdateTime = System.currentTimeMillis() + 10000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTaskState(TaskState taskState) {
            ArchiveLongTermTaskStatePublisher archiveLongTermTaskStatePublisher = ArchiveLongTermTaskStatePublisher.this;
            synchronized (archiveLongTermTaskStatePublisher) {
                if (this._taskState != taskState) {
                    long now = System.currentTimeMillis();
                    if (this._minorChanges) {
                        this.publishMinorChange(now);
                    }
                    this._taskState = taskState;
                    this._format = "";
                    this._progress = -1L;
                    this._maximumProgress = -1L;
                    this._progressResult = -1L;
                    this._minorChanges = false;
                    ArchiveLongTermTaskStatePublisher.this.publishMajorChanges(now);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTaskProgress(String format, long progress, long maximumProgress, long progressResult) {
            long now = System.currentTimeMillis();
            boolean publish = false;
            this._format = format;
            this._progress = progress;
            this._maximumProgress = maximumProgress;
            this._progressResult = progressResult;
            this._minorChanges = true;
            if (now > this._nextTaskUpdateTime) {
                publish = true;
            }
            if (publish) {
                Object object = ArchiveLongTermTaskStatePublisher.this;
                synchronized (object) {
                    ArchiveLongTermTaskStatePublisher.this.notifyMinorChanges(now);
                }
                object = this;
                synchronized (object) {
                    if (now > this._nextTaskUpdateTime) {
                        this.publishMinorChange(now);
                    }
                }
            }
        }

        private void publishMinorChange(long now) {
            ArchiveLongTermTaskStatePublisher.this._debug.info(this.toString());
            this.publishedMinorChanges(now);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ArchiveLongTermTaskStatePublisher.this._minorChangeHeaderText);
            stringBuilder.append(NEWLINE);
            this.appendTo(stringBuilder);
            return stringBuilder.toString();
        }

        private void appendTo(StringBuilder stringBuilder) {
            stringBuilder.append(this._taskName);
            stringBuilder.append(": ");
            stringBuilder.append(this._taskState.getStateName());
            if (!this._format.isEmpty()) {
                stringBuilder.append(": ");
                try (Formatter formatter = new Formatter(stringBuilder);){
                    formatter.format(this._format, this._progress, this._maximumProgress, this._progressResult);
                }
            }
        }

        @Override
        public synchronized String getProgressText() {
            return String.format(this._format, this._progress, this._maximumProgress, this._progressResult);
        }

        public void publishedMinorChanges(long now) {
            this._nextTaskUpdateTime = now + 10000L;
            this._minorChanges = false;
        }

        @Override
        public String getName() {
            return this._taskName;
        }

        @Override
        public TaskState getState() {
            return this._taskState;
        }

        @Override
        public long getProgress() {
            return this._progress;
        }

        @Override
        public long getMaximumProgress() {
            return this._maximumProgress;
        }

        @Override
        public synchronized long getProgressResult() {
            return this._progressResult;
        }
    }
}

