/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt;

import de.bsvrz.ars.ars.mgmt.ArchivConfig;
import de.bsvrz.ars.ars.mgmt.FreeDiskSpacePublisher;
import de.bsvrz.ars.ars.mgmt.InQueuesMgr;
import de.bsvrz.ars.ars.mgmt.QueueParameters;
import de.bsvrz.ars.ars.mgmt.RuntimeControl;
import de.bsvrz.ars.ars.mgmt.SystemRuntimeControl;
import de.bsvrz.ars.ars.mgmt.TaskManager;
import de.bsvrz.ars.ars.mgmt.commands.ArSCmdInterface;
import de.bsvrz.ars.ars.mgmt.simulation.SimulationManager;
import de.bsvrz.ars.ars.mgmt.tasks.Task;
import de.bsvrz.ars.ars.mgmt.tasks.scheduler.TaskScheduler;
import de.bsvrz.ars.ars.persistence.CacheManager;
import de.bsvrz.ars.ars.persistence.ContainerDataIterator;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.PersistenceManager;
import de.bsvrz.ars.ars.persistence.RebuildMode;
import de.bsvrz.ars.ars.persistence.ScanModes;
import de.bsvrz.ars.ars.persistence.directories.ActivePersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.WeekDomain;
import de.bsvrz.ars.ars.repair.Defect;
import de.bsvrz.ars.ars.repair.PersistenceCheckRunner;
import de.bsvrz.ars.ars.repair.RescueResult;
import de.bsvrz.ars.ars.repair.ScanMode;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.ConfigurationAuthority;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.bsvrz.sys.funclib.losb.DAVAppBase;
import de.bsvrz.sys.funclib.losb.kernsoftware.ConnectionManager;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

public class ArchiveManager
extends DAVAppBase
implements TaskManager {
    private static final int DEFAULT_CMD_PORT = 4242;
    private static final String P_PRINT_PARAMS = "-nurParametrierungAusgeben";
    private static final String P_PRINT_PARAMS_FILE = "-parametrierungAusgabeDatei";
    private static final String P_PERS_PATH = "-persistenzVerzeichnis";
    private static final String P_CHECK_PERS_DIR = "-persistenzVerzeichnisPruefen";
    private static final String P_REMOTE_CONTROL = "-kommandoPort";
    private static final String P_MAX_QUERIES_PER_APPLICATION = "-maxAnfragenProApplikation";
    private static final int DEFAULT_MAX_QUERIES_PER_APPLICATION = 5;
    private static final String P_REMOTE_CONTROL_NORC = "deaktiviert";
    private static final String P_REMOTE_CONTROL_DEFAULT = "default";
    private PersistenceManager persistenceMgr;
    private InQueuesMgr inQueuesMgr;
    private ArchivConfig archivConfig;
    private TaskScheduler taskScheduler;
    private SimulationManager simulationMgr;
    private boolean printParamsAndExit;
    private File printParamsFile;
    private ScanModes checkPersDirMode;
    private Path archivePath;
    private int maximumQueriesPerApplication;
    private int cmdPortNum = -1;
    private boolean terminated;
    private boolean runningProperly;
    private final Object _terminatedLock = new Object();
    private final TreeMap<SystemObject, Integer> _applicationToArchiveQueryCount;
    private Thread _shutDownHookThread;
    private int _numOfArchTasks = -1;
    private int _numCloseIndexThreads = -1;
    private int _numCheckPersistenceThreads = -1;
    private int _numDeleteThreads = -1;
    private long _minWaitNanosPerSubscription;
    private long _maxWaitNanosPerSubscription;
    private int _slidingWindowSize;
    private int _totalCapacityOfOnlineQueues = -1;
    private boolean _skipSystemExit;
    private int _indexCacheMaxSize;
    private String _archiveObjectPid;
    private RebuildMode rebuildMode;
    private final AtomicBoolean simulatePermanentDelete = new AtomicBoolean(true);

    public ArchiveManager(String[] args) throws Exception {
        super(args, "Archivsystem", () -> {
            Debug.getLogger().error("Verbindung zum Datenverteiler wurde fr\u00fchzeitig terminiert, Archivsystem wird beendet");
            System.exit(2);
        });
        try {
            Class.forName("de.bsvrz.dav.daf.util.FileAccess");
        }
        catch (ClassNotFoundException ignored) {
            Debug.getLogger().error("Das ArchivSystem ben\u00f6tigt die Kernsoftware in Mindestversion 3.9.6");
            System.exit(3);
        }
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        this._applicationToArchiveQueryCount = new TreeMap();
        this.logger = Debug.getLogger();
        try {
            this.parseArguments(this.argList);
        }
        catch (Exception e) {
            this.logger.error("Fehler beim Auswerten der Aufrufargumente: " + e.getMessage());
            e.printStackTrace(System.err);
            if (!this._skipSystemExit) {
                System.exit(4);
            }
            throw e;
        }
        try {
            if (!this.printParamsAndExit) {
                this.persistenceMgr = new PersistenceManager(this, this.archivePath, ArchiveManager.detectDomain(this.archivePath, false));
                this.persistenceMgr.initialize();
            }
            this.archivConfig = new ArchivConfig(this);
        }
        catch (Exception e) {
            this.logger.error("Fehler bei Initialisierung des Archivsystems", (Throwable)e);
            throw e;
        }
    }

    @Nullable
    public static WeekDomain detectDomain(Path archivePath, boolean silent) throws IOException {
        Debug debug = Debug.getLogger();
        WeekDomain weekDomain = new WeekDomain();
        if (!Files.isDirectory(archivePath, new LinkOption[0])) {
            if (!silent) {
                debug.warning("Initialisiere neues Wurzelverzeichnis: " + String.valueOf(archivePath.toAbsolutePath()));
            }
            Files.createDirectories(archivePath, new FileAttribute[0]);
            return weekDomain;
        }
        try (Stream<Path> stream = Files.list(archivePath);){
            List<Path> dirs = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(it -> !ArchiveManager.isBackupDir(it)).toList();
            if (dirs.isEmpty()) {
                if (!silent) {
                    debug.warning("Initialisiere leeres Wurzelverzeichnis: " + String.valueOf(archivePath.toAbsolutePath()));
                }
                WeekDomain weekDomain2 = weekDomain;
                return weekDomain2;
            }
            List<Path> validWeekDirs = dirs.stream().filter(WeekDomain::isYearDir).toList();
            if (!validWeekDirs.isEmpty()) {
                if (!silent) {
                    debug.info("Initialisiere bestehendes Wurzelverzeichnis mit " + validWeekDirs.size() + " Jahresverzeichnisse: " + String.valueOf(archivePath.toAbsolutePath()));
                }
                WeekDomain weekDomain3 = weekDomain;
                return weekDomain3;
            }
            if (dirs.stream().anyMatch(it -> it.getFileName().toString().startsWith("obj"))) {
                Path isOpenFile = archivePath.resolve(".isOpen.flag");
                if (!Files.exists(isOpenFile, new LinkOption[0])) {
                    Files.createFile(isOpenFile, new FileAttribute[0]);
                }
                if (!silent) {
                    ArchiveManager.warnAboutMigration(archivePath, debug);
                }
                WeekDomain weekDomain4 = null;
                return weekDomain4;
            }
            if (!silent) {
                debug.warning("Unbekannte Dateien im Wurzelverzeichnis: " + String.valueOf(dirs));
            }
            WeekDomain weekDomain5 = weekDomain;
            return weekDomain5;
        }
    }

    private static boolean isBackupDir(Path it) {
        return it.getFileName().toString().equals("backup");
    }

    private static void warnAboutMigration(Path archivePath, Debug debug) {
        debug.warning("--------------------------------------------------------------------------------------------------------\nDas \u00fcbergebene Persistenzverzeichnis wurde noch nicht in das Format von Version 6 migriert.\n\nDas Archivsystem Version 6 bietet eine kompakte, schnellere Verzeichnis-Struktur und verbesserte\nWartbarkeit, jedoch werden die Funktionen Auslagern, Wiederherstellen und L\u00f6schen nicht mehr\nunterst\u00fctzt.\n\nSollten Sie diese Funktionen weiterhin ben\u00f6tigen, wechseln Sie bitte zur\u00fcck auf Version 5.x.\n\nAnsonsten sollten Sie die Archivdaten mit z. B. folgendem Befehl in das neue Format konvertieren:\n\n    java -jar '%s' -src='%s' -dst='%s' -debugLevelStdErrText=INFO\n\nund zuk\u00fcnftig das Archivsystem mit -archiv='%3$s' starten.\n\nDie Konvertierung kann einige Zeit in Anspruch nehmen. W\u00e4hrend der Konvertierung k\u00f6nnen alle\nausgelagerten Daten wieder integriert werden. Dies ist nachtr\u00e4glich nicht mehr m\u00f6glich.\n\nDie Konvertierung darf nicht durchgef\u00fchrt werden, w\u00e4hrend das Archivsystem l\u00e4uft,\nda dadurch Inkonsistenzen entstehen k\u00f6nnten. Bei Bedarf kann (z. B. mit der konsistenten Datensicherung)\neine Kopie des Quellverzeichnisses erstellt werden.\n--------------------------------------------------------------------------------------------------------\n".formatted(ArchiveManager.swePath(), archivePath.toAbsolutePath(), ArchiveManager.suggestNewArchivePath(archivePath)));
    }

    private static String swePath() {
        URL location = ArchiveManager.class.getProtectionDomain().getCodeSource().getLocation();
        if (location == null) {
            return "de.bsvrz.ars.migration/de.bsvrz.ars.migration-runtime.jar";
        }
        try {
            String string = Paths.get(location.toURI()).toString();
            if (string.endsWith("-runtime.jar")) {
                return string.replace("de.bsvrz.ars.ars", "de.bsvrz.ars.migration");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return "de.bsvrz.ars.migration/de.bsvrz.ars.migration-runtime.jar";
    }

    private static Object suggestNewArchivePath(Path archivePath) {
        return archivePath.resolveSibling("archiv_neu");
    }

    public final ConfigurationObject getArchiveObject() {
        ConfigurationAuthority object = null;
        if (this._archiveObjectPid.isEmpty()) {
            object = this.getConfigAuth();
        } else {
            DataModel dataModel = this.getDataModel();
            if (dataModel != null) {
                SystemObject systemObject = dataModel.getObject(this._archiveObjectPid);
                if (systemObject instanceof ConfigurationObject) {
                    object = (ConfigurationObject)systemObject;
                } else {
                    throw new IllegalArgumentException("Das Archiv-Objekt vom typ.archiv konnte nicht bestimmt werden. Aufrufargument -archiv=" + this._archiveObjectPid + " pr\u00fcfen.");
                }
            }
        }
        if (object == null) {
            throw new IllegalArgumentException("Das Archiv-Objekt vom typ.archiv konnte nicht bestimmt werden. Eventuell besteht noch keine Datenverteiler-Verbindung.");
        }
        return object;
    }

    @Nullable
    public DataModel getDataModel() {
        ClientDavInterface connection = this.getDavCon();
        if (connection == null) {
            return null;
        }
        return connection.getDataModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasTerminated() {
        Object object = this._terminatedLock;
        synchronized (object) {
            return this.terminated;
        }
    }

    private void parseArguments(ArgumentList argLst) {
        this._skipSystemExit = argLst.fetchArgument("-noExit=false").booleanValue();
        CacheManager.getInstance().init(this.argList);
        this.printParamsAndExit = argLst.hasArgument(P_PRINT_PARAMS);
        this.printParamsFile = argLst.hasArgument(P_PRINT_PARAMS_FILE) ? argLst.fetchArgument(P_PRINT_PARAMS_FILE).asFile() : null;
        this.checkPersDirMode = argLst.hasArgument(P_CHECK_PERS_DIR) ? (ScanModes)((Object)argLst.fetchArgument(P_CHECK_PERS_DIR).asEnum(ScanModes.class)) : null;
        this.archivePath = argLst.hasArgument(P_PERS_PATH) ? Paths.get(argLst.fetchArgument(P_PERS_PATH).asString(), new String[0]) : null;
        String cmdPort = argLst.hasArgument(P_REMOTE_CONTROL) ? argLst.fetchArgument(P_REMOTE_CONTROL).asString() : null;
        this.maximumQueriesPerApplication = argLst.hasArgument(P_MAX_QUERIES_PER_APPLICATION) ? argLst.fetchArgument(P_MAX_QUERIES_PER_APPLICATION).intValueBetween(1, Integer.MAX_VALUE) : 5;
        this._archiveObjectPid = argLst.fetchArgument("-archiv=").asString();
        this.rebuildMode = (RebuildMode)((Object)argLst.fetchArgument("-wiederherstellungsModus=Quick").asEnum(RebuildMode.class));
        this._numOfArchTasks = argLst.fetchArgument("-archivierungsThreads=11").intValueBetween(1, Integer.MAX_VALUE);
        this.simulatePermanentDelete.set(!argLst.fetchArgument("-permanentLoeschen=nein").booleanValue());
        this._totalCapacityOfOnlineQueues = argLst.fetchArgument("-archivierungsPuffer=200000").intValueBetween(250, Integer.MAX_VALUE);
        this._numCloseIndexThreads = argLst.fetchArgument("-indexUpdateThreads=" + this.getNumOfArchTasks()).intValueBetween(1, Integer.MAX_VALUE);
        this._numCheckPersistenceThreads = argLst.fetchArgument("-pruefThreads=" + this.getNumOfArchTasks()).intValueBetween(1, Integer.MAX_VALUE);
        this._numDeleteThreads = argLst.fetchArgument("-lzvThreads=1").intValueBetween(1, Integer.MAX_VALUE);
        double minPerSecond = argLst.fetchArgument("-minAnmeldungenProSekunde=1").doubleValueBetween(1.0, Double.POSITIVE_INFINITY);
        double maxPerSecond = argLst.fetchArgument("-maxAnmeldungenProSekunde=Infinity").doubleValueBetween(1.0, Double.POSITIVE_INFINITY);
        this._slidingWindowSize = argLst.fetchArgument("-maxAnmeldungenGleichzeitig=1000").intValueBetween(1, 1000000);
        ContainerDataIterator.setOpenFileLimit(argLst.fetchArgument("-maxOffeneDateien=500").intValueBetween(1, Integer.MAX_VALUE));
        PersistenceManager.setDeleteBrokenContainers(argLst.fetchArgument("-defekteDateienVerschieben=false").booleanValue());
        this._indexCacheMaxSize = argLst.fetchArgument("-maxIndexBytes=16384").intValueBetween(1, Integer.MAX_VALUE);
        this._minWaitNanosPerSubscription = (long)(1.0E9 / maxPerSecond);
        this._maxWaitNanosPerSubscription = (long)(1.0E9 / minPerSecond);
        if (this.checkPersDirMode != null && this.archivePath == null) {
            this.quitError("Ung\u00fcltige Parameterkombination: -persistenzVerzeichnisPruefen erfordert -persistenzVerzeichnis");
        }
        argLst.ensureAllArgumentsUsed();
        if (this.checkPersDirMode != null && this.printParamsAndExit) {
            this.quitError("Ung\u00fcltige Parameterkombination: -persistenzVerzeichnisPruefen und -nurParametrierungAusgeben nicht gleichzeitig m\u00f6glich");
        }
        if (!this.printParamsAndExit && this.printParamsFile != null) {
            this.quitError("Ung\u00fcltige Parameterkombination: -parametrierungAusgabeDatei nur in Verbindung mit -nurParametrierungAusgeben m\u00f6glich");
        }
        if (!(this.printParamsAndExit && this.checkPersDirMode == null || this.archivePath != null)) {
            this.quitError("Ung\u00fcltige Parameterkombination: -persistenzVerzeichnis nicht vorhanden");
        }
        if (cmdPort != null && !cmdPort.equalsIgnoreCase(P_REMOTE_CONTROL_NORC)) {
            if (cmdPort.equals(P_REMOTE_CONTROL_DEFAULT)) {
                this.cmdPortNum = 4242;
            } else {
                try {
                    this.cmdPortNum = Integer.parseInt(cmdPort);
                }
                catch (NumberFormatException e) {
                    this.quitError("Ungueltiger Wert fuer -kommandoPort: '" + cmdPort + "'");
                }
            }
        }
    }

    public void run(RuntimeControl runtimeControl) {
        if (this.wasTerminated()) {
            this.logger.error("Das Archivsystem wurde bereits beendet.");
            throw new IllegalStateException("Das Archivsystem wurde bereits beendet.");
        }
        if (this.executeCheckMode()) {
            this.quit();
        } else if (this.executeSpecialModeWithDAV()) {
            this.quit();
        } else {
            this.logger.info("Archivsystem im Normalmodus gestartet");
            this.setDisconnectHandler(() -> this.quitError("Verbindung zum Datenverteiler wurde terminiert, Archivsystem wird kontrolliert beendet"));
            this._shutDownHookThread = new Thread(new ShutdownHook(this));
            Runtime.getRuntime().addShutdownHook(this._shutDownHookThread);
            this.runningProperly = true;
            QueueParameters parameters = new QueueParameters(this._totalCapacityOfOnlineQueues, this._minWaitNanosPerSubscription, this._maxWaitNanosPerSubscription, this._slidingWindowSize);
            this.inQueuesMgr = new InQueuesMgr(this, runtimeControl, this.persistenceMgr.getDataIdentTree(), parameters);
            this.taskScheduler = new TaskScheduler(this);
            this.simulationMgr = new SimulationManager(this);
            if (this.cmdPortNum != -1) {
                new ArSCmdInterface(this, this.cmdPortNum).start();
            }
            if (!this.wasTerminated()) {
                this.taskScheduler.start();
            }
            if (!this.persistenceMgr.startupProcedure(this.getRebuildMode())) {
                this.quitError("Fehler im Persistenzverzeichnis. Archivsystem kann nicht gestartet werden.");
            } else {
                this.enableExplicitApplicationReadyMessage();
                this.connectToDavQuit();
                if (!this.wasTerminated()) {
                    this.inQueuesMgr.getObjectsFromDav();
                }
                if (!this.wasTerminated()) {
                    this.inQueuesMgr.startAllTasks();
                }
                if (!this.wasTerminated()) {
                    this.inQueuesMgr.subscribeSettings();
                }
                if (!this.wasTerminated()) {
                    this.archivConfig.startSubscribeArchiveParams(this.inQueuesMgr, this.persistenceMgr.getDataIdentTree());
                }
                if (!this.wasTerminated()) {
                    this.simulationMgr.start();
                }
                if (!this.wasTerminated()) {
                    new FreeDiskSpacePublisher(this).start();
                }
            }
        }
    }

    @Override
    public RuntimeControl getRuntimeControl() {
        if (this.inQueuesMgr != null) {
            return this.inQueuesMgr.getRuntimeControl();
        }
        return null;
    }

    @Override
    public long countDataInQueues() {
        if (this.inQueuesMgr != null) {
            return this.inQueuesMgr.countDataInQueues();
        }
        return 0L;
    }

    @Override
    public long estimateQueueMemoryUsage() {
        if (this.inQueuesMgr != null) {
            return this.inQueuesMgr.estimateQueueMemoryUsage();
        }
        return 0L;
    }

    @Override
    public void suspendTaskIfNecessary(Task task) throws InterruptedException {
        if (this.inQueuesMgr != null) {
            this.inQueuesMgr.suspendTaskIfNecessary(task);
        }
    }

    public void connectToDavQuit() {
        try {
            this.connectToDav();
        }
        catch (Exception e) {
            this.quitError("Es konnte keine Verbindung zum Datenverteiler aufgebaut werden.\n" + e.getMessage());
        }
    }

    private boolean executeCheckMode() {
        if (this.checkPersDirMode != null) {
            this.logger.info("Archivsystem zur Pr\u00fcfung des Persistenzverzeichnisses gestartet");
            this.checkPersistenceDir(this.checkPersDirMode.get());
            return true;
        }
        return false;
    }

    public void checkPersistenceDir(ScanMode mode) {
        ActivePersistenceDirectory activePersistenceDirectory = this.persistenceMgr.getActivePersistenceDirectory(0);
        if (activePersistenceDirectory == null) {
            return;
        }
        try {
            RescueResult result = PersistenceCheckRunner.scan(activePersistenceDirectory, mode);
            this.printDetails("Gel\u00f6schte Containerdateien, denen das letzte Byte fehlt", result.getOneByteShortDefects());
            this.printDetails("Gel\u00f6schte Containerdateien, bei denen der maximale Datenindex falsch ist", result.getBadRangeEndDefects());
            this.printDetails("Containerdateien mit abgeschnittenen Daten", result.getBadContainerFileEnd());
            this.printDetails("Containerdateien ohne Daten", result.getShortContainerFiles());
            this.printDetails("Defekte Indexdateien", result.getBadIndexFiles());
            this.printDetails("Sonstige Probleme", result.getCantFix());
            this.logger.info("# gepr\u00fcfte Container:        " + result.getCheckedContainerFileCount() + Debug.NEWLINE + "# Container ohne Defekte:    " + result.getValidContainerFileCount() + Debug.NEWLINE + "# Container mit Defekten:    " + result.getDefectContainerFileCount() + Debug.NEWLINE + "# gepr\u00fcfte Indexdateien:     " + result.getCheckedIndexFileCount() + Debug.NEWLINE + "# Indexdateien ohne Defekte: " + result.getValidIndexFileCount() + Debug.NEWLINE + "# Indexdateien mit Defekten: " + result.getDefectIndexFileCount() + Debug.NEWLINE + "# korrigierbare Defekte:     " + result.getFixableDefectsCount() + Debug.NEWLINE + "# " + result.getDataIdentificationsVisited() + " Datenidentifikationen untersucht." + Debug.NEWLINE + "# Ergebnis: " + (result.isConsistent() ? "Das Archiv ist in einem konsistenten Zustand." : "Es sind Fehler aufgetreten."));
            if (mode.fixErrors()) {
                PersistenceCheckRunner.fixDefects(result, activePersistenceDirectory.getLayoutInstance());
            }
        }
        catch (PersistenceException e) {
            this.logger.error("Konsistenzpr\u00fcfung abgebrochen", (Throwable)e);
        }
    }

    private void printDetails(String title, Set<Defect> defects) {
        if (defects.isEmpty()) {
            return;
        }
        this.logger.info(title + ":" + Debug.NEWLINE + "# Anzahl: " + defects.size() + Debug.NEWLINE + "# Details nur in Debug-Level FINE");
        for (Defect defect : defects) {
            this.logger.fine(String.valueOf(defect.getFile()) + Debug.NEWLINE + defect.getMessage(), (Throwable)defect.getException());
        }
    }

    private boolean executeSpecialModeWithDAV() {
        if (this.printParamsAndExit) {
            this.connectToDavQuit();
            this.logger.info("Archivsystem zur Parameterausgabe " + (String)(this.printParamsFile == null ? "auf der Konsole" : "in '" + this.printParamsFile.getAbsolutePath() + "'") + " gestartet");
            try {
                this.archivConfig.printArchiveParams(this.printParamsFile);
            }
            catch (Exception e) {
                this.logger.error("Parameterausgabe fehlgeschlagen: " + e.getMessage());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        Object object = this._terminatedLock;
        synchronized (object) {
            boolean wasTerminated = this.terminated;
            this.terminated = true;
            if (wasTerminated) {
                return;
            }
            try {
                this.logger.info("Beende Task Scheduler...");
                if (this.taskScheduler != null) {
                    this.taskScheduler.terminate();
                }
                this.logger.info("Task Scheduler beendet");
                this.logger.info("Melde Archivdaten ab...");
                if (this.archivConfig != null) {
                    this.archivConfig.unsubscribeArchiveData();
                }
                this.logger.info("Archivdaten abgemeldet");
                this.logger.info("Melde Archivparametrierung ab...");
                if (this.archivConfig != null) {
                    this.archivConfig.unsubscribeArchiveParams();
                }
                this.logger.info("Archivparametrierung abgemeldet");
                this.logger.info("Melde Simulation ab...");
                if (this.simulationMgr != null) {
                    this.simulationMgr.terminateTask();
                }
                this.logger.info("Simulation abgemeldet");
                this.logger.info("Beende Tasks...");
                if (this.inQueuesMgr != null) {
                    this.inQueuesMgr.stopAllTasks();
                }
                this.logger.info("Tasks beendet");
                if (this.persistenceMgr != null) {
                    this.persistenceMgr.saveUnsubscriptionTime();
                }
                this.logger.info("Melde sonstige Parameter ab...");
                if (this.getDavCon() != null) {
                    ConnectionManager.unsubscribeAll((ClientDavInterface)this.getDavCon());
                }
                this.logger.info("Sonstige Parameter abgemeldet");
                this.logger.info("Melde Quittungen ab...");
                if (this.archivConfig != null) {
                    this.archivConfig.unsubscribeArchiveDataAck();
                }
                this.logger.info("Quittungen abgemeldet");
                this.logger.info("Warte auf SettingsManager...");
                if (this.archivConfig != null) {
                    this.archivConfig.terminateTask();
                    this.archivConfig.join();
                }
                this.logger.info("SettingsManager beendet");
                this.logger.info("Starte Finalisierung...");
                if (this.persistenceMgr != null && this.runningProperly) {
                    this.persistenceMgr.prepareShutdown();
                }
                this.logger.info("Finalisierung beendet (Indexe geschrieben, Lock-Datei gel\u00f6scht)");
            }
            catch (Exception e) {
                this.logger.warning("Fehler beim Herunterfahren", (Throwable)e);
            }
            this.disconnectFromDav();
            this.persistenceMgr = null;
            this.inQueuesMgr = null;
            this.archivConfig = null;
            this.taskScheduler = null;
            this.simulationMgr = null;
        }
    }

    public void quit() {
        this.logger.info("Archivsystem wird beendet.");
        this.cleanUp();
        this.logger.info("Bye.");
        if (!this._skipSystemExit) {
            System.exit(0);
        }
    }

    public void quitNoExit() {
        if (!this.wasTerminated()) {
            this.logger.info("Archivsystem wird beendet - Java-VM laeuft weiter");
            this.cleanUp();
            this.logger.info("Bye.");
        }
    }

    public void quitError(String msg) {
        this.logger.error(msg);
        this.logger.info("Archivsystem wird wegen eines Fehlers beendet.");
        if (this.inQueuesMgr != null) {
            this.inQueuesMgr.setFastExit(true);
        }
        this.cleanUp();
        this.logger.info("Bye (with error). " + msg);
        if (this._skipSystemExit) {
            throw new RuntimeException(msg);
        }
        System.exit(1);
    }

    private void dumpThreads() {
        StringBuilder out = new StringBuilder();
        out.append("Full thread dump\n");
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
            StackTraceElement[] trace;
            out.append("\n");
            Thread thread = entry.getKey();
            out.append(String.format("\"%s@%d\"%s prio=%d tid=0x%x%n", thread.getName(), thread.getId(), thread.isDaemon() ? " daemon" : "", thread.getPriority(), thread.getId()));
            for (StackTraceElement traceElement : trace = entry.getValue()) {
                out.append("\t  at ").append(traceElement).append("\n");
            }
        }
        this.logger.info(out.toString());
    }

    public void quitErrorNoExit(String msg) {
        if (this.inQueuesMgr != null) {
            this.inQueuesMgr.setFastExit(true);
        }
        if (!this.wasTerminated()) {
            this.logger.error(msg);
            this.logger.info("Archivsystem wird wegen eines Fehlers beendet.");
            this.dumpThreads();
            this.cleanUp();
            this.logger.info("Bye (with error).");
        }
    }

    public static void main(String[] args) {
        try {
            ArchiveManager am = new ArchiveManager(args);
            am.run(new SystemRuntimeControl());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.exit(4);
        }
    }

    public ArchivConfig getArchivConfig() {
        return this.archivConfig;
    }

    public InQueuesMgr getInQueuesMgr() {
        return this.inQueuesMgr;
    }

    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public SimulationManager getSimulationMgr() {
        return this.simulationMgr;
    }

    public int getMaximumQueriesPerApplication() {
        return this.maximumQueriesPerApplication;
    }

    public List<String> getOriginalCommandLineArguments() {
        ArrayList result = new ArrayList();
        Collections.addAll(result, this.argList.getInitialArgumentStrings());
        return Collections.unmodifiableList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int increaseArchiveQueryCountForApplication(SystemObject application) {
        TreeMap<SystemObject, Integer> treeMap = this._applicationToArchiveQueryCount;
        synchronized (treeMap) {
            Integer queryCount = this._applicationToArchiveQueryCount.get(application);
            int newCount = queryCount == null ? 1 : queryCount + 1;
            this._applicationToArchiveQueryCount.put(application, newCount);
            return newCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseArchiveQueryCountForApplication(SystemObject application) {
        TreeMap<SystemObject, Integer> treeMap = this._applicationToArchiveQueryCount;
        synchronized (treeMap) {
            Integer queryCount = this._applicationToArchiveQueryCount.get(application);
            if (queryCount == null) {
                throw new IllegalStateException("Anzahl Archivanfragen f\u00fcr Applikation " + String.valueOf(application) + " darf nicht kleiner als 0 werden");
            }
            int newCount = queryCount - 1;
            if (newCount == 0) {
                this._applicationToArchiveQueryCount.remove(application);
            } else {
                this._applicationToArchiveQueryCount.put(application, newCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getArchiveQueryCountForApplication(SystemObject application) {
        TreeMap<SystemObject, Integer> treeMap = this._applicationToArchiveQueryCount;
        synchronized (treeMap) {
            Integer queryCount = this._applicationToArchiveQueryCount.get(application);
            return queryCount == null ? 0 : queryCount;
        }
    }

    @Override
    public int getNumCloseIndexThreads() {
        return this._numCloseIndexThreads;
    }

    @Override
    public int getNumCheckPersistenceThreads() {
        return this._numCheckPersistenceThreads;
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return this.persistenceMgr;
    }

    public int getNumOfArchTasks() {
        return this._numOfArchTasks;
    }

    public int getNumDeleteThreads() {
        return this._numDeleteThreads;
    }

    public void archiveIsReady() {
        this.logger.info("Das Archivsystem ist bereit f\u00fcr Anfragen.");
        this.getInQueuesMgr().subscribeQueries();
        this.getDavCon().sendApplicationReadyMessage();
    }

    @Override
    public int getIndexCacheMaxSize() {
        return this._indexCacheMaxSize;
    }

    public RebuildMode getRebuildMode() {
        return this.rebuildMode;
    }

    public boolean simulatePermanentDelete() {
        return this.simulatePermanentDelete.get();
    }

    public void togglePermanentDelete() {
        this.simulatePermanentDelete.set(!this.simulatePermanentDelete.get());
    }

    private class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private volatile byte[] _reserve = new byte[20000];

        private ExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (e instanceof Error && this._reserve != null) {
                this._reserve = null;
                try {
                    System.err.println("Schwerwiegender Laufzeitfehler: Ein Thread hat sich wegen eines Errors beendet, Prozess wird terminiert");
                    System.err.println(t);
                    e.printStackTrace(System.err);
                    ArchiveManager.this.logger.error("Schwerwiegender Laufzeitfehler: " + String.valueOf(t) + " hat sich wegen eines Errors beendet, Prozess wird terminiert", e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (ArchiveManager.this._shutDownHookThread != null) {
                        Runtime.getRuntime().removeShutdownHook(ArchiveManager.this._shutDownHookThread);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!ArchiveManager.this._skipSystemExit) {
                    System.exit(5);
                }
            } else {
                System.err.println("Laufzeitfehler: Ein Thread hat sich wegen einer Exception beendet:");
                System.err.println(t);
                e.printStackTrace(System.err);
                ArchiveManager.this.logger.error("Laufzeitfehler: " + String.valueOf(t) + " hat sich wegen einer Exception beendet", e);
            }
        }
    }

    private static class ShutdownHook
    implements Runnable {
        private final WeakReference<ArchiveManager> _archiveManager;

        public ShutdownHook(ArchiveManager archiveManager) {
            this._archiveManager = new WeakReference<ArchiveManager>(archiveManager);
        }

        @Override
        public void run() {
            ArchiveManager archiveManager = (ArchiveManager)this._archiveManager.get();
            if (archiveManager != null) {
                archiveManager.quitErrorNoExit("Terminierungssignal empfangen, Archivsystem wird kontrolliert beendet");
            }
        }
    }
}

