/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt;

import de.bsvrz.ars.ars.mgmt.ArchiveLongTermTaskStatePublisher;
import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.LongTermTaskStatePublisher;
import de.bsvrz.ars.ars.mgmt.tasks.ArchiveSettingsTask;
import de.bsvrz.ars.ars.mgmt.tasks.DeletePermanentlyTask;
import de.bsvrz.ars.ars.mgmt.tasks.DeleteSimVarTask;
import de.bsvrz.ars.ars.mgmt.tasks.MirrorTask;
import de.bsvrz.ars.ars.mgmt.tasks.NumQueriesInfoTask;
import de.bsvrz.ars.ars.mgmt.tasks.RequestGapTask;
import de.bsvrz.ars.ars.mgmt.tasks.Task;
import java.util.Collection;
import java.util.List;

public class BackgroundTaskManager {
    final LongTermTaskStatePublisher _longTermTaskStatePublisher;
    private final ArchiveManager archMgr;
    final DeletePermanentlyTask deletePermanentlyTask;
    final ArchiveSettingsTask archiveSettingsTask;
    final DeleteSimVarTask deleteSimVarTask;
    final RequestGapTask requestGapTask;
    final NumQueriesInfoTask numQueriesInfoTask;
    final MirrorTask mirrorTask;

    public BackgroundTaskManager(ArchiveManager archMgr) {
        this._longTermTaskStatePublisher = new ArchiveLongTermTaskStatePublisher(archMgr, "Zustands\u00e4nderung eines Hintergrundprozesses:", "Zust\u00e4nde der Hintergrundprozesse:");
        this.archMgr = archMgr;
        this.deletePermanentlyTask = new DeletePermanentlyTask(archMgr, this._longTermTaskStatePublisher, archMgr.getNumDeleteThreads());
        this.archiveSettingsTask = new ArchiveSettingsTask(archMgr);
        this.deleteSimVarTask = new DeleteSimVarTask(archMgr);
        this.requestGapTask = new RequestGapTask(archMgr);
        this.numQueriesInfoTask = new NumQueriesInfoTask(archMgr);
        this.mirrorTask = new MirrorTask(archMgr, this._longTermTaskStatePublisher);
    }

    void startBackgroundTasks() {
        this._longTermTaskStatePublisher.setDavConnection(this.archMgr.getDavCon());
        for (Task task : this.getBackgroundTasks()) {
            task.start();
        }
    }

    void stopBackgroundTasks() {
        for (Task task : this.getBackgroundTasks()) {
            task.terminateTask();
        }
    }

    Collection<? extends Task> getBackgroundTasks() {
        return List.of(this.deletePermanentlyTask, this.archiveSettingsTask, this.deleteSimVarTask, this.requestGapTask, this.numQueriesInfoTask, this.mirrorTask);
    }

    public ArchiveSettingsTask getArchiveSettingsTask() {
        return this.archiveSettingsTask;
    }

    public DeletePermanentlyTask getDeletePermanentlyTask() {
        return this.deletePermanentlyTask;
    }

    public RequestGapTask getRequestGapTask() {
        return this.requestGapTask;
    }

    public DeleteSimVarTask getDeleteSimVarTask() {
        return this.deleteSimVarTask;
    }

    public NumQueriesInfoTask getNumQueriesInfoTask() {
        return this.numQueriesInfoTask;
    }

    public MirrorTask getMirrorTask() {
        return this.mirrorTask;
    }
}

