/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.persistence.directories.ActivePersistenceDirectory;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.util.cron.CronDefinition;
import de.bsvrz.dav.daf.util.cron.CronScheduler;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public class FreeDiskSpacePublisher
implements ClientSenderInterface {
    private static final Debug _debug = Debug.getLogger();
    private final ArchiveManager _archMgr;
    private DataDescription _dataDescription;
    private final CronScheduler cronScheduler = new CronScheduler();

    public FreeDiskSpacePublisher(ArchiveManager archMgr) {
        this._archMgr = archMgr;
        ClientDavInterface clientDavInterface = this._archMgr.getDavCon();
        DataModel dataModel = clientDavInterface.getDataModel();
        AttributeGroup atg = dataModel.getAttributeGroup("atg.archivSpeicherplatz");
        Aspect asp = dataModel.getAspect("asp.archivSystem");
        if (atg == null || asp == null) {
            _debug.info("Kann freien Speicherplatz nicht ver\u00f6ffentlichen, ben\u00f6tigte Attributgruppe und/oder Aspekt sind nicht im Datenmodell vorhanden. Es wird mindestens Version 37 von kb.systemModellGlobal.config ben\u00f6tigt.");
            return;
        }
        this._dataDescription = new DataDescription(atg, asp);
        try {
            long freeMemory = -1L;
            try {
                freeMemory = Files.getFileStore(this._archMgr.getPersistenceManager().getRootPath()).getUsableSpace();
            }
            catch (Exception e) {
                _debug.warning("Fehler beim Ermitteln des freien Speicherplatzes", (Throwable)e);
            }
            clientDavInterface.subscribeSource((ClientSenderInterface)this, this.createResult(freeMemory));
        }
        catch (Exception e) {
            _debug.info("Kann freien Speicherplatz nicht ver\u00f6ffentlichen", (Throwable)e);
        }
    }

    private ResultData createResult(long freeMemory) {
        Data data;
        if (freeMemory < 0L) {
            data = null;
        } else {
            _debug.info(String.format("Freier Speicherplatz: %6.3f MB", (double)freeMemory / 1048576.0));
            data = this._archMgr.getDavCon().createData(this._dataDescription.getAttributeGroup());
            data.getUnscaledValue("FreierSpeicherplatz").set(freeMemory);
        }
        return new ResultData((SystemObject)this._archMgr.getArchiveObject(), this._dataDescription, System.currentTimeMillis(), data);
    }

    void sendFreeSpace(long freeDiskSpace) {
        if (this._dataDescription == null) {
            return;
        }
        try {
            this._archMgr.getDavCon().sendData(this.createResult(freeDiskSpace));
        }
        catch (Exception e) {
            _debug.info("Kann freien Speicherplatz nicht ver\u00f6ffentlichen", (Throwable)e);
        }
    }

    public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
    }

    public boolean isRequestSupported(SystemObject object, DataDescription dataDescription) {
        return false;
    }

    public void start() {
        this.cronScheduler.schedule(() -> {
            ActivePersistenceDirectory activePersistenceDirectory = this._archMgr.getPersistenceManager().getActivePersistenceDirectory(0);
            Path basePath = activePersistenceDirectory != null ? activePersistenceDirectory.getBasePath() : this._archMgr.getPersistenceManager().getRootPath();
            try {
                long freeSpace = Files.getFileStore(basePath).getUsableSpace();
                this.sendFreeSpace(freeSpace);
            }
            catch (IOException e) {
                _debug.info("Kann freien Speicherplatz nicht ermitteln", (Throwable)e);
                this.sendFreeSpace(-1L);
            }
        }, CronDefinition.EVERY_MINUTE);
    }
}

