/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.commands;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.commands.ArchiveMonitor;
import de.bsvrz.ars.ars.mgmt.commands.CreateIndexesCommand;
import de.bsvrz.ars.ars.mgmt.commands.DataIdentInfo;
import de.bsvrz.ars.ars.mgmt.commands.EjectPersistenceDirectoriesCommand;
import de.bsvrz.ars.ars.mgmt.commands.EnableDeleteCommand;
import de.bsvrz.ars.ars.mgmt.commands.LargeContainerDirDump;
import de.bsvrz.ars.ars.mgmt.commands.ListPersistenceDirectoriesCommand;
import de.bsvrz.ars.ars.mgmt.commands.LoadPersistenceDirectoriesCommand;
import de.bsvrz.ars.ars.mgmt.commands.MemoryDumpCmd;
import de.bsvrz.ars.ars.mgmt.tasks.ArchiveQueryTask;
import de.bsvrz.ars.ars.mgmt.tasks.scheduler.TaskScheduler;
import de.bsvrz.ars.ars.persistence.directories.mgmt.PersistenceDirectoryManager;
import de.bsvrz.ars.ars.persistence.directories.mgmt.TimeBasedPersistenceDirectoryManager;
import de.bsvrz.ars.ars.persistence.layout.ShortPersistenceDirectoryLayout;
import de.bsvrz.ars.ars.persistence.writer.ArchiveTask;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.losb.datk.ContainerSettings;
import de.bsvrz.sys.funclib.losb.util.Util;
import de.bsvrz.sys.funclib.losb.util.cmdinterface.CmdInterpreter;
import de.bsvrz.sys.funclib.losb.util.cmdinterface.CmdMenu;
import de.bsvrz.sys.funclib.losb.util.cmdinterface.Command;
import de.bsvrz.sys.funclib.losb.util.cmdinterface.HiddenCommand;
import de.bsvrz.sys.funclib.losb.util.cmdinterface.InfoCommands;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ArSCmdInterface {
    public static final int SEND_TIMEOUT = 300;
    private static final int QUIT_CMD_NR = 5;
    private final ArchiveManager archMgr;
    private final CmdInterpreter cmdInt;

    public ArSCmdInterface(ArchiveManager am, int port) {
        int timeout = 10;
        this.archMgr = am;
        this.cmdInt = new CmdInterpreter(port, 10);
        CmdMenu root = new CmdMenu("Archivsystem", "");
        CmdMenu subMenu = new CmdMenu("Einstellungen", "");
        root.addNode(subMenu);
        subMenu.addCmd((Command)new EnableDeleteCommand(am));
        CmdMenu debugLevelMenu = InfoCommands.getDebugLevelMenu();
        subMenu.addNode(debugLevelMenu);
        subMenu.addCmd(new Command(this, "Debug-Level ausgeben", ""){

            public void execute() throws Exception {
                this.println("Angemeldete Logger:\n" + Debug.debugInfo());
            }
        });
        subMenu = new CmdMenu("Archivinformationen", "");
        root.addNode(subMenu);
        subMenu.addCmd((Command)new DataIdentInfo(this.archMgr));
        subMenu.addCmd(new Command("Auslastung der Archivierungs-Warteschlange", "Beenden mit 'q'"){

            public void execute() throws Exception {
                block3: {
                    this.println("Ausgabe kann mit 'q' und Enter beendet werden.");
                    this.println("Die Ausgabe wird unterdr\u00fcckt, wenn sie sich zur vorherigen nicht ge\u00e4ndert hat.");
                    this.println("Aktualisierungsrate in Millisekunden:");
                    ArchiveMonitor monitor = null;
                    try {
                        int n = Integer.parseInt(this.readln());
                        monitor = new ArchiveMonitor(ArSCmdInterface.this.archMgr, n, this);
                        monitor.start();
                    }
                    catch (Exception e) {
                        this.println("Ung\u00fcltige Eingabe!");
                    }
                    while (!this.readln().equalsIgnoreCase("q")) {
                    }
                    if (monitor == null) break block3;
                    monitor.terminate();
                }
            }
        });
        subMenu.addCmd(InfoCommands.memoryInfo());
        subMenu.addCmd(InfoCommands.runtimeInfo());
        subMenu.addCmd(InfoCommands.systemInfo());
        subMenu.addCmd(new Command("Archiveinstellungen", ""){

            public void execute() throws Exception {
                TaskScheduler ts = ArSCmdInterface.this.archMgr.getTaskScheduler();
                this.printlnPlain("TMax:                    " + Util.relTimestrMillis((long)ArSCmdInterface.this.archMgr.getInQueuesMgr().getArchiveDataReceiver().getTMaxATimeForwardStep()));
                this.printlnPlain("Endueltiger Loeschtask");
                this.printlnPlain("  Letzter Lauf:          " + ts.getDeletePermanentlyLastRun());
                this.printlnPlain("  Aktuelle Einstellung:  " + ts.getDeletePermanentlyIntervals());
                this.printlnPlain("  Naechster Lauf:        " + ts.getDeletePermanentlyNextRun());
                this.printlnPlain("");
                this.printlnPlain("Nachforderungstask");
                this.printlnPlain("  Letzter Lauf:          " + ts.getRequestLastRun());
                this.printlnPlain("  Aktuelle Einstellung:  " + ts.getRequestIntervals());
                this.printlnPlain("  Naechster Lauf:        " + ts.getRequestNextRun());
                this.printlnPlain("");
                this.printlnPlain("Anzahl Bytes:            " + ArchiveQueryTask.getBufferSizeMux());
                this.printlnPlain("Anzahl Blocks:           " + ArchiveQueryTask.getBlockingFactorMux());
                this.printlnPlain("");
                this.printlnPlain("par. Anfr. hohe Prio.:   " + ArSCmdInterface.this.archMgr.getInQueuesMgr().getHiQueryTaskNum());
                this.printlnPlain("par. Anfr. mitt. Prio.:  " + ArSCmdInterface.this.archMgr.getInQueuesMgr().getMidQueryTaskNum());
                this.printlnPlain("par. Anfr. niedr. Prio.: " + ArSCmdInterface.this.archMgr.getInQueuesMgr().getLoQueryTaskNum());
            }
        });
        subMenu.addCmd(new Command("Container Abschlussparameter", ""){

            public void execute() throws Exception {
                ContainerSettings settings = ArchiveTask.getContainerSettings();
                this.printlnPlain("Anz. Datensaetze = " + Util.kiloBlocks((long)settings.stdCloseConditions.maxContAnzDS) + " Stk.");
                this.printlnPlain("Cont. Groesse    = " + Util.kiloBlocks((long)settings.stdCloseConditions.maxContSize) + " Byte");
                this.printlnPlain("Zeitspanne Cont. = " + Util.relTimestr((long)settings.stdCloseConditions.maxContTime));
                if (!settings.exceptions.isEmpty()) {
                    this.printlnPlain(" Ausnahmen:");
                    for (ContainerSettings.ContSettingsExc cSettingsEx : settings.exceptions) {
                        Iterator it = cSettingsEx.atgSet.iterator();
                        while (it.hasNext()) {
                            Long appId = (Long)it.next();
                            if (it.hasNext()) {
                                this.printlnPlain("  " + ArSCmdInterface.this.archMgr.getAtg(appId).getPidOrNameOrId() + ",");
                                continue;
                            }
                            this.printlnPlain("  " + ArSCmdInterface.this.archMgr.getAtg(appId).getPidOrNameOrId() + " = ");
                            this.printlnPlain("      " + Util.kiloBlocks((long)cSettingsEx.excCloseConditions.maxContAnzDS) + " Stk., " + Util.kiloBlocks((long)cSettingsEx.excCloseConditions.maxContSize) + " Byte, " + Util.relTimestr((long)cSettingsEx.excCloseConditions.maxContTime));
                        }
                    }
                }
            }
        });
        subMenu.addCmd((Command)new MemoryDumpCmd("Arbeitsspeicher-Analyse", "", this.archMgr));
        subMenu.addCmd((Command)new LargeContainerDirDump("\u00dcbergro\u00dfe Containerverzeichnisse", "", this.archMgr));
        subMenu = new CmdMenu("System Info", "");
        root.addNode(subMenu);
        subMenu.addCmd(new Command("Command Line Arguments", ""){

            public void execute() throws Exception {
                List<String> ocla = ArSCmdInterface.this.archMgr.getOriginalCommandLineArguments();
                for (String arg : ocla) {
                    this.printlnPlain("  " + arg);
                }
            }
        });
        subMenu.addCmd(new Command(this, "Environment", ""){

            public void execute() throws Exception {
                Map<String, String> map = System.getenv();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    this.printlnPlain("  " + entry.getKey() + "=" + entry.getValue());
                }
            }
        });
        subMenu.addCmd(new Command(this, "System Properties", ""){

            public void execute() throws Exception {
                Properties props = System.getProperties();
                for (String s : props.stringPropertyNames()) {
                    this.printlnPlain("  " + s + "=" + props.getProperty(s));
                }
            }
        });
        PersistenceDirectoryManager persistenceDirectoryManager = am.getPersistenceManager().getPersistenceDirectoryManager();
        if (persistenceDirectoryManager instanceof TimeBasedPersistenceDirectoryManager) {
            TimeBasedPersistenceDirectoryManager manager = (TimeBasedPersistenceDirectoryManager)persistenceDirectoryManager;
            CmdMenu childMenu = new CmdMenu("Persistenzverzeichnisse", "Persistenzverzeichnisse einh\u00e4ngen und auswerfen");
            childMenu.addCmd(new ListPersistenceDirectoriesCommand(manager));
            childMenu.addCmd(new EjectPersistenceDirectoriesCommand(manager));
            childMenu.addCmd(new LoadPersistenceDirectoriesCommand(manager));
            root.addNode(childMenu);
        }
        root.addCmd((Command)new CreateIndexesCommand(am));
        root.addCmd(new Command("Converter ID<->PID", ""){

            public void execute() throws Exception {
                this.printlnPlain("Bitte geben Sie eine ID oder eine PID oder einen komprimierten Ordnernamen ein.");
                String eingabe = this.readln();
                if (eingabe == null || eingabe.isBlank()) {
                    this.printlnPlain("Bitte geben Sie einen Wert ein.");
                } else {
                    eingabe = eingabe.trim();
                    try {
                        SystemObject obj;
                        long id = ShortPersistenceDirectoryLayout.decodeFast(eingabe);
                        if (id == -1L) {
                            id = Long.parseLong(eingabe);
                        }
                        if ((obj = ArSCmdInterface.this.archMgr.getObj(id)) != null) {
                            this.printlnPlain("  ID: " + id + "   PID: " + obj.getPid() + "   Name: " + obj.getName());
                        } else {
                            this.printlnPlain("  Die ID " + eingabe + " ist nicht bekannt.");
                        }
                        this.printlnPlain("  Kodierte ID: " + ShortPersistenceDirectoryLayout.encode(id));
                    }
                    catch (Exception e) {
                        try {
                            SystemObject obj = ArSCmdInterface.this.archMgr.getObj(eingabe);
                            if (obj != null) {
                                this.printlnPlain("  PID: " + eingabe + "   ID: " + obj.getId() + "   Name: " + obj.getName());
                                this.printlnPlain("  Kodierte ID: " + ShortPersistenceDirectoryLayout.encode(obj.getId()));
                            } else {
                                this.printlnPlain("  Die PID " + eingabe + " ist nicht bekannt.");
                            }
                        }
                        catch (Exception ex) {
                            this.printlnPlain("Unbekannter Fehler: " + ex.getMessage());
                        }
                    }
                }
            }
        });
        root.addCmd(new Command("Archivsystem stoppen", ""){

            public void execute() throws Exception {
                this.println("Soll das Archivsystem beendet werden? [j|n]");
                if (this.readln().equals("j")) {
                    Debug.getLogger().info("Archivsystem per Kommandoverbindung beendet");
                    ArSCmdInterface.this.archMgr.quit();
                }
            }
        });
        root.addCmd((Command)new HiddenCommand("Gesamtanzahl der online-aktuellen Datens\u00e4tze", 131008){

            public void execute() throws Exception {
                this.println(String.valueOf(ArSCmdInterface.this.archMgr.getInQueuesMgr().countDataInQueues()));
            }
        });
        root.addCmd((Command)new HiddenCommand("Archivsystem sofort terminieren", 131009){

            public void execute() {
                ArSCmdInterface.this.archMgr.quitError("Archivsystem wurde \u00fcber Telnet sofort terminiert");
            }
        });
        this.cmdInt.setMenu(root);
    }

    public void start() {
        this.cmdInt.start();
    }

    public static void sendQuitCmd(String host, int port) throws IOException {
        try (Socket connection = new Socket(host, port);){
            connection.setSoTimeout(300000);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.ISO_8859_1));
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.ISO_8859_1));
            ArSCmdInterface.readPrompt(in);
            ArSCmdInterface.write(out, String.valueOf(5));
            ArSCmdInterface.readPrompt(in);
            ArSCmdInterface.write(out, "j");
            in.readLine();
        }
    }

    private static void readPrompt(BufferedReader in) throws IOException {
        while (!in.readLine().endsWith(CmdInterpreter.PROMPT)) {
        }
    }

    private static void write(BufferedWriter out, String s) throws IOException {
        out.write(s);
        out.newLine();
        out.flush();
    }
}

