/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.commands;

import com.google.common.base.Splitter;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.TimeDomain;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.TimeRange;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.WeekDomain;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.bsvrz.sys.funclib.losb.util.cmdinterface.Command;
import java.text.ParseException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class DomainUtil {
    private static final DateTimeFormatter _formatter = DateTimeFormatter.ofPattern("dd. MMMM yyyy").withLocale(Locale.GERMANY).withResolverStyle(ResolverStyle.LENIENT);
    private static final DateTimeFormatter _parserAlt0 = DateTimeFormatter.ofPattern("d.[ ]MMMM yyyy").withLocale(Locale.GERMANY).withResolverStyle(ResolverStyle.LENIENT);
    private static final DateTimeFormatter _parserAlt1 = DateTimeFormatter.ofPattern("d.[ ]M.[ ]yy").withLocale(Locale.GERMANY).withResolverStyle(ResolverStyle.LENIENT);
    private static final DateTimeFormatter _parserAlt2 = DateTimeFormatter.ofPattern("d.[ ]M.[ ]yyyy").withLocale(Locale.GERMANY).withResolverStyle(ResolverStyle.LENIENT);

    public static <T extends TimeRange<T>> TreeRangeSet<LocalDate> stringToValue(String text, TimeDomain<T> domain) throws ParseException {
        TreeRangeSet set = TreeRangeSet.create();
        try {
            Iterable split = Splitter.on((String)";").trimResults().omitEmptyStrings().split((CharSequence)text);
            for (String pair : split) {
                List foo = Splitter.on((String)"bis").limit(2).trimResults().splitToList((CharSequence)pair);
                if (foo.size() == 2) {
                    set.add(DomainUtil.parseRange((String)foo.get(0), domain).span(DomainUtil.parseRange((String)foo.get(1), domain)));
                    continue;
                }
                if (foo.size() != 1) continue;
                set.add(DomainUtil.parseRange((String)foo.get(0), domain));
            }
        }
        catch (DateTimeParseException e) {
            throw new ParseException(e.getMessage(), e.getErrorIndex());
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        return set;
    }

    @NotNull
    private static <T extends TimeRange<T>> Range<LocalDate> parseRange(String s, TimeDomain<T> domain) {
        if (s.matches("\\d{4}")) {
            int year = Integer.parseInt(s);
            LocalDate startDate = LocalDate.ofYearDay(year, 1);
            LocalDate endDate = startDate.plusYears(1L);
            if (domain instanceof WeekDomain) {
                startDate = DomainUtil.getNextSunday(startDate);
            }
            return Range.closedOpen((Comparable)startDate, (Comparable)endDate);
        }
        return Range.closedOpen((Comparable)DomainUtil.parse(s), (Comparable)DomainUtil.parse(s).plusDays(1L));
    }

    public static LocalDate getNextSunday(LocalDate date) {
        int daysUntilNextSunday = DayOfWeek.SUNDAY.getValue() - date.getDayOfWeek().getValue();
        return date.plusDays(daysUntilNextSunday);
    }

    @Nullable
    public static <T extends TimeRange<T>> Set<T> getTimeRangesFromUser(Command command, TimeDomain<T> domain) throws Exception {
        command.printlnPlain("  z. B. \"2012\" oder \"01.01.2020 bis 16.05.2021\"");
        TreeRangeSet<LocalDate> rangeSet = null;
        while (rangeSet == null) {
            String range = command.readln();
            if (range.isBlank()) {
                return null;
            }
            try {
                rangeSet = DomainUtil.stringToValue(range, domain);
            }
            catch (Exception e) {
                command.printlnPlain("Ung\u00fcltige Eingabe: \"" + range + "\"");
            }
        }
        command.printlnPlain("  Angegebener Zeitbereich:");
        command.printlnPlain("  " + DomainUtil.format(rangeSet));
        command.printlnPlain("  Zugeh\u00f6rige Wochenverzeichnisse:");
        LinkedHashSet<T> timeRanges = new LinkedHashSet<T>();
        for (Range range : rangeSet.asRanges()) {
            Range adjustedRange = Range.range((Comparable)((LocalDate)range.lowerEndpoint()).atStartOfDay().atOffset(ZoneOffset.UTC).toInstant(), (BoundType)range.lowerBoundType(), (Comparable)((LocalDate)range.upperEndpoint()).atStartOfDay().atOffset(ZoneOffset.UTC).toInstant(), (BoundType)range.upperBoundType());
            timeRanges.addAll(domain.getIntervals((Range<Instant>)adjustedRange));
        }
        for (TimeRange timeRange : timeRanges) {
            command.printlnPlain("  " + String.valueOf(domain.getPath(timeRange)));
        }
        command.printlnPlain("  Fortfahren? (j/N)");
        String readLn = command.readln();
        if (readLn.equalsIgnoreCase("j")) {
            return timeRanges;
        }
        command.printlnPlain("  Abgebrochen.");
        return null;
    }

    private static LocalDate parse(String s) {
        try {
            return LocalDate.parse(s, _parserAlt0);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return LocalDate.parse(s, _parserAlt1);
            }
            catch (DateTimeParseException dateTimeParseException2) {
                return LocalDate.parse(s, _parserAlt2);
            }
        }
    }

    @NotNull
    public static String format(RangeSet<? extends LocalDate> value) {
        Set ranges = value.asRanges();
        StringBuilder builder = new StringBuilder();
        Iterator iterator = ranges.iterator();
        while (iterator.hasNext()) {
            Range range = (Range)iterator.next();
            if (((LocalDate)range.lowerEndpoint()).equals(((LocalDate)range.upperEndpoint()).minusDays(1L))) {
                builder.append(((LocalDate)range.lowerEndpoint()).format(_formatter));
            } else {
                builder.append(((LocalDate)range.lowerEndpoint()).format(_formatter)).append(" bis ").append(((LocalDate)range.upperEndpoint()).minusDays(1L).format(_formatter));
            }
            if (!iterator.hasNext()) continue;
            builder.append("; ");
        }
        return builder.toString();
    }
}

