/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.commands;

import de.bsvrz.ars.ars.mgmt.commands.DomainUtil;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.mgmt.TimeBasedPersistenceDirectoryManager;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.TimeDomain;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.TimeRange;
import de.bsvrz.sys.funclib.losb.util.cmdinterface.Command;
import java.util.Set;

public class EjectPersistenceDirectoriesCommand<T extends TimeRange<T>>
extends Command {
    private final TimeBasedPersistenceDirectoryManager<T> directoryManager;

    public EjectPersistenceDirectoriesCommand(TimeBasedPersistenceDirectoryManager<T> directoryManager) {
        super("Verzeichnisse auswerfen", "");
        this.directoryManager = directoryManager;
    }

    public void execute() throws Exception {
        this.printlnPlain("  Zeitbereich, der ausgeworfen werden soll:");
        TimeDomain<TimeRange> domain = this.directoryManager.getDomain();
        Set<TimeRange> timeRanges = DomainUtil.getTimeRangesFromUser(this, domain);
        if (timeRanges == null) {
            return;
        }
        for (TimeRange timeRange : timeRanges) {
            PersistenceDirectory directory = this.directoryManager.getPersistenceDirectory(timeRange);
            if (directory == null) {
                this.printlnPlain("  " + String.valueOf(domain.getPath(timeRange)) + ": Verzeichnis ist nicht eingebunden.");
                continue;
            }
            boolean b = this.directoryManager.removePersistenceDirectory(timeRange);
            if (b) {
                this.printlnPlain("  " + String.valueOf(domain.getPath(timeRange)) + ": Erfolgreich ausgeworfen.");
                continue;
            }
            this.printlnPlain("  " + String.valueOf(domain.getPath(timeRange)) + ": Auswerfen aktuell nicht m\u00f6glich.");
        }
    }
}

