/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.commands;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import de.bsvrz.ars.ars.mgmt.commands.DomainUtil;
import de.bsvrz.ars.ars.persistence.directories.mgmt.TimeBasedPersistenceDirectoryManager;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.TimeDomain;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.TimeRange;
import de.bsvrz.sys.funclib.losb.util.cmdinterface.Command;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.Set;

public class LoadPersistenceDirectoriesCommand<T extends TimeRange<T>>
extends Command {
    private final TimeBasedPersistenceDirectoryManager<T> directoryManager;

    public LoadPersistenceDirectoriesCommand(TimeBasedPersistenceDirectoryManager<T> directoryManager) {
        super("Verzeichnisse hinzuf\u00fcgen", "");
        this.directoryManager = directoryManager;
    }

    public void execute() throws Exception {
        TreeRangeSet availableRanges = TreeRangeSet.create();
        this.printlnPlain("  Folgende Zeitbereiche k\u00f6nnen integriert werden:");
        this.directoryManager.executeOnSubDirectories(p -> {
            Range<LocalDate> timeRange = this.detectUnloadedPath(p);
            if (timeRange != null) {
                availableRanges.add(timeRange);
            }
        });
        if (availableRanges.isEmpty()) {
            this.printlnPlain("  Es gibt keine Verzeichnisse, die hinzugef\u00fcgt werden k\u00f6nnen.");
            return;
        }
        TimeDomain<TimeRange> domain = this.directoryManager.getDomain();
        this.printlnPlain("  " + DomainUtil.format((RangeSet<? extends LocalDate>)availableRanges));
        this.printlnPlain("  Zeitbereich, der integriert werden soll:");
        Set<TimeRange> timeRanges = DomainUtil.getTimeRangesFromUser(this, domain);
        if (timeRanges == null) {
            return;
        }
        for (TimeRange timeRange : timeRanges) {
            boolean b = this.directoryManager.addPersistenceDirectory(timeRange);
            if (b) {
                this.printlnPlain("  " + String.valueOf(domain.getPath(timeRange)) + ": Erfolgreich hinzugef\u00fcgt.");
                continue;
            }
            this.printlnPlain("  " + String.valueOf(domain.getPath(timeRange)) + ": Hinzuf\u00fcgen aktuell nicht m\u00f6glich.");
        }
    }

    private Range<LocalDate> detectUnloadedPath(Path path) {
        T timeRange = this.directoryManager.getId(path);
        if (timeRange == null) {
            return null;
        }
        if (this.directoryManager.getPersistenceDirectory(timeRange) == null) {
            return timeRange.getDayRange();
        }
        return null;
    }
}

