/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.commands;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.persistence.PersistenceManager;
import de.bsvrz.sys.funclib.losb.util.cmdinterface.Command;

public class MemoryDumpCmd
extends Command {
    private final ArchiveManager _archMgr;

    public MemoryDumpCmd(String desc, String help, ArchiveManager archMgr) {
        super(desc, help);
        this._archMgr = archMgr;
    }

    public void execute() throws Exception {
        PersistenceManager.Statistics statistics = this._archMgr.getPersistenceManager().getStatistics();
        this.printlnPlain("Aktueller Arbeitsspeicherverbrauch: ");
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        this.printlnPlain(String.format("%n%9.3f MB insgesamt, davon", (double)usedMemory / 1048576.0));
        this.printlnPlain(String.format("%n%9.3f MB zur Synchronisierung", (double)statistics.getLockMemory() / 1048576.0));
        this.printlnPlain(String.format("%n%9.3f MB f\u00fcr %d Datenknoten", (double)statistics.getNodeMemory() / 1048576.0, statistics.getNumNodes()));
        this.printlnPlain(String.format("%n%9.3f MB f\u00fcr %d offene Container", (double)statistics.getActiveMemory() / 1048576.0, statistics.getNumOpenContainerData()));
        this.printlnPlain(String.format("%n%9.3f MB f\u00fcr %d Datens\u00e4tze in der Warteschlange", (double)statistics.getQueueMemory() / 1048576.0, statistics.getQueueSize()));
        this.printlnPlain(String.format("%n%9.3f MB zwischengespeichert f\u00fcr Archivierungs-Cache (davon %.0f%% ungenutzt)", (double)statistics.getCachedMemory().totalBytesUsed() / 1048576.0, 100.0 - 100.0 * (double)statistics.getCachedMemory().cachedBytes() / (double)statistics.getCachedMemory().totalBytesUsed()));
    }
}

