/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.datatree;

import de.bsvrz.ars.ars.mgmt.datatree.DataIdentNode;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.dav.daf.main.Dataset;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.dataIdentificationSettings.DataIdentification;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class DataIdentTree
implements Iterable<DataIdentNode> {
    private final Map<IdDataIdentification, DataIdentNode> _nodeMap = new ConcurrentHashMap<IdDataIdentification, DataIdentNode>();

    public DataIdentNode get(DataIdentification did) {
        return this.get(new IdDataIdentification(did));
    }

    public DataIdentNode get(Dataset rd) {
        return this.get(new IdDataIdentification(rd));
    }

    public DataIdentNode get(IdDataIdentification idDataIdentification) {
        return this._nodeMap.computeIfAbsent(idDataIdentification, DataIdentNode::new);
    }

    @Nullable
    public DataIdentNode getIfPresent(IdDataIdentification idDataIdentification) {
        return this._nodeMap.get(idDataIdentification);
    }

    public synchronized void deleteDataIdentNode(IdDataIdentification did) {
        this._nodeMap.remove(did);
    }

    public List<SystemObject> getObjects(DataModel model) {
        return model.getObjects(this._nodeMap.keySet().stream().mapToLong(IdDataIdentification::getObjectId).distinct().toArray());
    }

    public List<SystemObject> getAtgs(long objId, DataModel model) {
        return model.getObjects(this._nodeMap.keySet().stream().filter(it -> it.getObjectId() == objId).mapToLong(IdDataIdentification::getAtgId).distinct().toArray());
    }

    public List<SystemObject> getAsps(long objId, long atgId, DataModel model) {
        return model.getObjects(this._nodeMap.keySet().stream().filter(it -> it.getObjectId() == objId && it.getAtgId() == atgId).mapToLong(IdDataIdentification::getAspectId).distinct().toArray());
    }

    public int[] getSimVars(long objId, long atgId, long aspId) {
        return this._nodeMap.keySet().stream().filter(it -> it.getObjectId() == objId && it.getAtgId() == atgId && it.getAspectId() == aspId).mapToInt(IdDataIdentification::getSimVariant).sorted().toArray();
    }

    public int size() {
        return this._nodeMap.size();
    }

    @Override
    @NotNull
    public Iterator<DataIdentNode> iterator() {
        return this._nodeMap.values().iterator();
    }
}

