/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.datatree;

import de.bsvrz.ars.ars.mgmt.datatree.IndexImpl;
import de.bsvrz.ars.ars.persistence.ContainerDirectory;
import de.bsvrz.ars.ars.persistence.IdContainerFileDir;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import java.nio.file.Path;
import java.util.Objects;

public final class IndexId {
    private final IdContainerFileDir _containerFileDir;
    private final IndexImpl _indexClass;

    public IndexId(IdContainerFileDir containerFileDir, IndexImpl indexClass) {
        this._containerFileDir = Objects.requireNonNull(containerFileDir);
        this._indexClass = Objects.requireNonNull(indexClass);
    }

    public IndexId(ContainerDirectory containerFileDir, IndexImpl indexClass) {
        this._containerFileDir = IdContainerFileDir.of(containerFileDir);
        this._indexClass = Objects.requireNonNull(indexClass);
    }

    public Path toFile(PersistenceDirectory persistenceDirectory) {
        return persistenceDirectory.getPath(this._containerFileDir).resolve(this._indexClass.getFileName());
    }

    public IdContainerFileDir getContainerFileDir() {
        return this._containerFileDir;
    }

    public IndexImpl getIndexClass() {
        return this._indexClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexId indexId = (IndexId)o;
        if (!this._containerFileDir.equals(indexId._containerFileDir)) {
            return false;
        }
        return this._indexClass == indexId._indexClass;
    }

    public int hashCode() {
        int result = this._containerFileDir.hashCode();
        result = 31 * result + this._indexClass.hashCode();
        return result;
    }

    public String toString() {
        return "IndexId{_containerFileDir=" + String.valueOf(this._containerFileDir) + ", _indexClass=" + String.valueOf((Object)this._indexClass) + "}";
    }
}

