/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.datatree.synchronization;

import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SyncKey;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.time.Duration;
import java.util.Collection;

public class SynchronizationFailedException
extends Exception {
    public SynchronizationFailedException(@Nullable Duration timeout, Object element, Collection<? extends SyncKey<?>> otherLocks, @Nullable Throwable parent) {
        super(SynchronizationFailedException.constructMessage(timeout, element, otherLocks), parent);
        for (SyncKey<?> otherLock : otherLocks) {
            ThreadDump tmp = new ThreadDump(otherLock.getThread());
            tmp.setStackTrace(otherLock.getThread().getStackTrace());
            this.addSuppressed(tmp);
        }
    }

    private static String constructMessage(@Nullable Duration timeout, Object element, Collection<? extends SyncKey<?>> otherLocks) {
        Thread myThread = Thread.currentThread();
        Thread otherThread = otherLocks.stream().limit(1L).map(SyncKey::getThread).findAny().orElse(null);
        StringBuilder result = new StringBuilder();
        result.append("Thread '").append(myThread).append("' konnte nicht auf '").append(element).append("' synchronisieren. ");
        if (timeout != null) {
            result.append("Timeout: ").append(SynchronizationFailedException.formatDuration(timeout)).append(". ");
        }
        if (otherThread != null) {
            result.append("Ressource wird durch Thread '").append(otherThread).append("' belegt.");
        }
        return result.toString();
    }

    private static String formatDuration(Duration runtime) {
        long days = runtime.toDays();
        long hours = runtime.toHours() % 24L;
        long minutes = runtime.toMinutes() % 60L;
        long seconds = runtime.getSeconds() % 60L;
        if (hours == 0L) {
            return String.format("%02d:%02d", minutes, seconds);
        }
        if (days == 0L) {
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        if (days == 1L) {
            return String.format("1 Tag, %02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%d Tage, %02d:%02d:%02d", days, hours, minutes, seconds);
    }

    private static class ThreadDump
    extends Throwable {
        public ThreadDump(Thread thread) {
            super(thread.toString());
        }
    }
}

