/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.simulation;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.simulation.OfflineSimulation;
import de.bsvrz.ars.ars.mgmt.simulation.OnlineSimulation;
import de.bsvrz.ars.ars.mgmt.simulation.SimulationManager;
import de.bsvrz.ars.ars.mgmt.simulation.SimulationResultData;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SendSubscriptionNotConfirmed;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.losb.exceptions.FailureException;
import de.bsvrz.sys.funclib.losb.kernsoftware.ConnectionManager;
import java.util.concurrent.LinkedBlockingQueue;

public sealed class SimulationAutomaton
implements ClientReceiverInterface,
SimulationManager.Transition
permits OfflineSimulation, OnlineSimulation {
    public static final int UNDEFINED = -1;
    private static final int CREATED = -2;
    private static final int SUBSCRIBED = -3;
    protected static final int NEW = 0;
    protected static final int INIT = 1;
    protected static final int START = 2;
    protected static final int PAUSE = 5;
    protected static final int STOP = 3;
    protected static final int ERASED = 4;
    private int state = -2;
    private final Debug debug = Debug.getLogger();
    private final SystemObject simulation;
    private final SystemObject simulationRange;
    private final LinkedBlockingQueue<Integer> transitions;
    private final short simVar;
    private boolean noSource;
    private final DataDescription simulationControl;
    private final SimulationManager simManager;
    private StateSender _stateSender;

    public SimulationAutomaton(SimulationManager simManager, SystemObject simulation, DataDescription simulationControl) {
        if (simulationControl.getAspect() == null || simulationControl.getAttributeGroup() == null) {
            throw new IllegalArgumentException("Ung\u00fcltige DataDescription: " + String.valueOf(simulationControl));
        }
        if (simulation == null) {
            throw new IllegalArgumentException("Simulationsobjekt ist null.");
        }
        this.simManager = simManager;
        this.simulation = simulation;
        this.simulationControl = simulationControl;
        this.transitions = new LinkedBlockingQueue();
        AttributeGroup atgProperties = simManager.getDav().getDataModel().getAttributeGroup("atg.simulationsEigenschaften");
        Data properties = simulation.getConfigurationData(atgProperties);
        this.simulationRange = properties.getReferenceValue("SimulationsStreckenReferenz").getSystemObject();
        this.simVar = properties.getUnscaledValue("SimulationsVariante").shortValue();
        if (this.simVar < 0 || this.simVar > 999) {
            throw new IllegalStateException("Simulationsvariante au\u00dferhalb des Wertebereiches: " + String.valueOf(properties));
        }
    }

    private void subscribeSimulation() {
        try {
            ConnectionManager.subscribeReceiver((ClientDavInterface)this.simManager.getDav(), (ClientReceiverInterface)this, (SystemObject)this.simulation, (DataDescription)this.simulationControl, (ReceiveOptions)ReceiveOptions.normal(), (ReceiverRole)ReceiverRole.receiver());
        }
        catch (FailureException e) {
            this.debug.error("", (Throwable)e);
        }
    }

    private void unsubscribeSimulation() {
        ConnectionManager.unsubscribeReceiver((ClientDavInterface)this.simManager.getDav(), (ClientReceiverInterface)this, (SystemObject)this.simulation, (DataDescription)this.simulationControl);
    }

    private void subscribeSimulationRange() {
        try {
            DataDescription dd = new DataDescription(this.simManager.getDav().getDataModel().getAttributeGroup("atg.simulationsDatenArchivierung"), this.simManager.getDav().getDataModel().getAspect("asp.parameterSoll"));
            ConnectionManager.subscribeReceiver((ClientDavInterface)this.simManager.getDav(), (ClientReceiverInterface)this, (SystemObject)this.simulationRange, (DataDescription)dd, (ReceiveOptions)ReceiveOptions.normal(), (ReceiverRole)ReceiverRole.receiver());
        }
        catch (FailureException e) {
            this.debug.error("", (Throwable)e);
        }
    }

    private void unsubscribeSimulationRange() {
        DataDescription dd = new DataDescription(this.simManager.getDav().getDataModel().getAttributeGroup("atg.simulationsDatenArchivierung"), this.simManager.getDav().getDataModel().getAspect("asp.parameterSoll"));
        ConnectionManager.unsubscribeReceiver((ClientDavInterface)this.simManager.getDav(), (ClientReceiverInterface)this, (SystemObject)this.simulationRange, (DataDescription)dd);
    }

    public synchronized boolean transition() {
        if (this.state == -2) {
            this.state = -3;
            this.subscribeSimulation();
            this.subscribeSimulationState();
            return true;
        }
        Integer newState = this.transitions.poll();
        if (newState == null) {
            return false;
        }
        if (this.state == -3 && newState == 0 || this.state == 0 && newState == 1 || this.state == 1 && newState == 2 || this.state == 2 && (newState == 3 || newState == 5) || this.state == 5 && (newState == 2 || newState == 5 || newState == 3) || this.state == 3 && (newState == 1 || newState == 4)) {
            this.debug.fine("Zustands\u00fcbergang der Simulation " + this.simVar + ": " + this.state + " -> " + newState);
            this.state = newState;
            switch (this.state) {
                case 0: {
                    this.enterNewState();
                    break;
                }
                case 1: {
                    this.enterInitState();
                    break;
                }
                case 2: {
                    this.enterStartState();
                    break;
                }
                case 3: {
                    this.enterStopState();
                    break;
                }
                case 4: {
                    this.enterErasedState();
                }
            }
            return true;
        }
        if (this.state == -3) {
            if (newState == 1) {
                this.debug.fine("Zustands\u00fcbergang der Simulation " + this.simVar + ": " + this.state + " -> " + newState);
                this.enterNewState();
                this.state = 1;
                this.enterInitState();
                return true;
            }
            this.debug.warning("Nicht erlaubter Zustands\u00fcbergang der Simulation " + this.simVar + ": " + this.state + " -> " + newState);
            this.sendSimulationState(false);
            return false;
        }
        this.debug.warning("Nicht erlaubter Zustands\u00fcbergang der Simulation " + this.simVar + ": " + this.state + " -> " + newState);
        return false;
    }

    protected void enterNewState() {
        this.sendSimulationState(false);
    }

    protected void enterInitState() {
        SimulationResultData ard = new SimulationResultData(this);
        this.simManager.insertDeleteQuery(ard);
    }

    protected void continueInitStateGetParams() {
        this.subscribeSimulationRange();
        ArchiveManager archiveManager = this.simManager.getArchMgr();
        archiveManager.getPersistenceManager().getPersistenceDirectoryManager().createSimulationDirectory(this.simVar);
    }

    protected void continueInitStateSubscribe(ResultData resultData) {
        SimulationResultData ard = new SimulationResultData(this, resultData);
        this.simManager.getArchMgr().getInQueuesMgr().insertSimVarParam(ard);
    }

    protected void finishInitState(boolean successful) {
        if (!successful) {
            this.state = -1;
        }
        this.sendSimulationState(successful);
    }

    protected void enterStartState() {
        this.unsubscribeSimulationRange();
    }

    protected void enterStopState() {
        this.sendSimulationState(false);
        this.simManager.getArchMgr().getArchivConfig().unsubscribeSimVarData(this.getSimVar());
    }

    protected void enterErasedState() {
        SimulationResultData srd = new SimulationResultData(this);
        this.simManager.insertDeleteQuery(srd);
    }

    protected void finishErasedState() {
        this.sendSimulationState(false);
        this.unsubscribeSimulationState();
    }

    private void subscribeSimulationState() {
        ClientDavInterface daf = this.simManager.getDav();
        DataModel model = daf.getDataModel();
        AttributeGroup atg = model.getAttributeGroup("atg.simulationsStatusArchiv");
        DataDescription dd = new DataDescription(atg, model.getAspect("asp.zustand"));
        try {
            this._stateSender = new StateSender();
            daf.subscribeSender((ClientSenderInterface)this._stateSender, this.simulation, dd, SenderRole.source());
        }
        catch (OneSubscriptionPerSendData e) {
            this.debug.warning("Mehrfachanmeldung auf Simulationszustand, Simulation: " + String.valueOf(this.simulation), (Throwable)e);
        }
    }

    private void unsubscribeSimulationState() {
        StateSender stateSender = this._stateSender;
        if (stateSender != null) {
            this._stateSender = null;
            ClientDavInterface daf = this.simManager.getDav();
            DataModel model = daf.getDataModel();
            AttributeGroup atg = model.getAttributeGroup("atg.simulationsStatusArchiv");
            DataDescription dd = new DataDescription(atg, model.getAspect("asp.zustand"));
            try {
                daf.unsubscribeSender((ClientSenderInterface)stateSender, this.simulation, dd);
            }
            catch (Exception e) {
                this.debug.warning("Abmeldung auf Simulationszustand nicht m\u00f6glich, Simulation: " + String.valueOf(this.simulation), (Throwable)e);
            }
        }
    }

    protected boolean sendSimulationState(boolean archiveReady) {
        if (this._stateSender == null) {
            this.debug.warning("Versand des Simulationszustands nicht m\u00f6glich, weil nicht angemeldet, Simulation: " + String.valueOf(this.simulation));
            return false;
        }
        ClientDavInterface daf = this.simManager.getDav();
        DataModel model = daf.getDataModel();
        AttributeGroup atg = model.getAttributeGroup("atg.simulationsStatusArchiv");
        DataDescription dd = new DataDescription(atg, model.getAspect("asp.zustand"));
        Data data = daf.createData(atg);
        data.getUnscaledValue("ArchivBereit").set(archiveReady ? 1 : 0);
        try {
            daf.sendData(new ResultData(this.simulation, dd, System.currentTimeMillis(), data));
            return true;
        }
        catch (SendSubscriptionNotConfirmed e) {
            this.debug.warning("Versand des Simulationszustands nicht m\u00f6glich, Simulation: " + String.valueOf(this.simulation), (Throwable)e);
            return false;
        }
    }

    protected void unsubscribe() {
        if (this._stateSender != null) {
            this.sendSimulationState(false);
            this.unsubscribeSimulationState();
        }
    }

    public void dataDeleted(boolean successful) {
        if (!successful) {
            this.debug.warning("Es konnten nicht alle Simulationsdaten gel\u00f6scht werden.");
        }
        if (this.state == 1) {
            this.continueInitStateGetParams();
        } else if (this.state == 4) {
            this.finishErasedState();
        }
    }

    public void terminate() {
        this.unsubscribeSimulation();
        if (this.state != 4) {
            this.unsubscribe();
        }
        this.state = -1;
    }

    public void update(ResultData[] results) {
        for (ResultData result : results) {
            try {
                if (result.getObject().equals((Object)this.simulation)) {
                    if (result.getDataState().equals(DataState.NO_SOURCE)) {
                        if (this.state != -3) {
                            this.noSource = true;
                            this.simManager.addWakeUp(this);
                            continue;
                        }
                        this.sendSimulationState(false);
                        continue;
                    }
                    if (!result.hasData()) continue;
                    if (this.noSource) {
                        this.noSource = false;
                        this.simManager.cancelWakeUp(this);
                    }
                    Data data = result.getData();
                    int i = (int)data.getUnscaledValue("SimulationsZustand").getState().getValue();
                    this.transitions.put(i);
                    this.simManager.addTransition(this);
                    continue;
                }
                if (!result.getObject().equals((Object)this.simulationRange) || !result.hasData()) continue;
                this.continueInitStateSubscribe(result);
            }
            catch (Exception npe) {
                Debug.getLogger().warning("Fehler beim Auswerten der eingehenden Daten. Daten werden ignoriert! " + String.valueOf(result), (Throwable)npe);
            }
        }
    }

    public void wakeUp() {
        if (!this.sendSimulationState(false)) {
            this.debug.fine("Kontakt zur Smulationssteuerung verloren. Senden einer Statusmeldung nicht m\u00f6glich.");
        }
        this.simManager.getArchMgr().getArchivConfig().unsubscribeSimVarData(this.getSimVar());
    }

    public short getSimVar() {
        return this.simVar;
    }

    public String toString() {
        return "SimulationAutomaton{state=" + this.state + ", simulation=" + String.valueOf(this.simulation) + ", simVar=" + this.simVar + "}";
    }

    private static class StateSender
    implements ClientSenderInterface {
        private StateSender() {
        }

        public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
        }

        public boolean isRequestSupported(SystemObject object, DataDescription dataDescription) {
            return false;
        }
    }
}

