/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.simulation;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.simulation.OfflineSimulation;
import de.bsvrz.ars.ars.mgmt.simulation.OnlineSimulation;
import de.bsvrz.ars.ars.mgmt.simulation.SimulationAutomaton;
import de.bsvrz.ars.ars.mgmt.simulation.SimulationResultData;
import de.bsvrz.ars.ars.mgmt.simulation.WakeUpManager;
import de.bsvrz.ars.ars.mgmt.tasks.RepeatingTask;
import de.bsvrz.ars.ars.persistence.util.SignalingQueue;
import de.bsvrz.ars.ars.persistence.util.TerminatedException;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.MutableSet;
import de.bsvrz.dav.daf.main.config.MutableSetChangeListener;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;

public class SimulationManager
extends RepeatingTask
implements MutableSetChangeListener {
    private MutableSet mutableSet;
    private final HashMap<SystemObject, SimulationAutomaton> simulations = new HashMap();
    private final SignalingQueue<Transition> transitions = new SignalingQueue();
    private final WakeUpManager wakeUp = new WakeUpManager();
    private long wakeUpTime = 120000L;
    private static final Debug logger = Debug.getLogger();

    public SimulationManager(ArchiveManager archMgr) {
        super(archMgr);
    }

    @Override
    public void start() {
        this.mutableSet = this.getArchMgr().getArchiveObject().getMutableSet("Simulationen");
        if (this.mutableSet == null) {
            logger.warning("Fehler bei der Abfrage von Konfigurationsdaten. Mutable Set \"Simulationen\" steht nicht zur Verf\u00fcgung. Simulation deaktiviert.");
        } else {
            this.mutableSet.addChangeListener((MutableSetChangeListener)this);
            this.update(this.mutableSet, this.mutableSet.getElements().toArray(new SystemObject[0]), new SystemObject[0]);
            super.start();
        }
    }

    public void update(MutableSet set, SystemObject[] addedObjects, SystemObject[] removedObjects) {
        try {
            if (set != null && set.equals((Object)this.mutableSet)) {
                if (this.simulations.size() + addedObjects.length - removedObjects.length > 1000) {
                    logger.warning("Zu viele Simulationen gestartet! Es werden keine weiteren Simulationen gestartet, bis die Anzahl der Simulationen unter 1000 sinkt.");
                } else {
                    for (SystemObject simulation : addedObjects) {
                        if (this.simulations.get(simulation) != null) {
                            logger.error("Es existiert bereits eine eingetragene Simulation f\u00fcr " + String.valueOf(simulation) + ": " + String.valueOf(this.simulations.get(simulation)));
                            continue;
                        }
                        SimulationAutomaton dfa = null;
                        switch (simulation.getType().getPid()) {
                            case "typ.onlineSimulation": {
                                dfa = new OnlineSimulation(this, simulation);
                                break;
                            }
                            case "typ.offlineSimulation": {
                                dfa = new OfflineSimulation(this, simulation);
                                break;
                            }
                            default: {
                                logger.warning("Unbekanntes Simulationsobjekt: " + String.valueOf(simulation));
                            }
                        }
                        if (dfa == null) continue;
                        this.simulations.put(simulation, dfa);
                        this.transitions.add(dfa);
                    }
                }
                Arrays.asList(removedObjects).forEach(this.simulations::remove);
            }
        }
        catch (Exception ex) {
            StringBuilder sb = new StringBuilder();
            sb.append("Set: ").append(this.mutableSet);
            sb.append("Hinzugef\u00fcgte Objekte: ");
            if (addedObjects != null) {
                for (SystemObject so : addedObjects) {
                    sb.append(so.getPid()).append(", ");
                }
            }
            sb.append("Entfernte Objekte: ");
            if (removedObjects != null) {
                for (SystemObject so : removedObjects) {
                    sb.append(so.getPid()).append(", ");
                }
            }
            Debug.getLogger().warning("Fehler beim Auswerten der eingehenden Daten. Daten werden ignoriert! " + String.valueOf(sb), (Throwable)ex);
        }
    }

    public ClientDavInterface getDav() {
        return this.getArchMgr().getDavCon();
    }

    void addTransition(@NotNull Transition dfa) {
        this.transitions.add(dfa);
    }

    public void addWakeUp(SimulationAutomaton dfa) {
        this.wakeUp.addWakeUp(this, dfa, System.currentTimeMillis() + this.wakeUpTime);
    }

    public void cancelWakeUp(SimulationAutomaton dfa) {
        this.wakeUp.cancelWakeUp(dfa);
    }

    @Override
    public void step() throws InterruptedException {
        SimulationAutomaton simulationAutomaton;
        boolean transitioned;
        Transition transition;
        this.wakeUp.wakeUp();
        try {
            long timeToWakeUp = this.wakeUp.timeToWakeUp();
            transition = timeToWakeUp == 0L ? this.transitions.take() : this.transitions.take(Duration.ofMillis(timeToWakeUp));
        }
        catch (TerminatedException e) {
            return;
        }
        if (transition instanceof SimulationAutomaton && !(transitioned = (simulationAutomaton = (SimulationAutomaton)transition).transition())) {
            _debug.fine("\u00dcbergang fehlgeschlagen");
        }
        this.taskStepDone();
    }

    @Override
    public void terminateTask() {
        super.terminateTask();
        this.transitions.terminateNow();
    }

    @Override
    protected void cleanUp() {
        if (this.mutableSet != null) {
            this.mutableSet.removeChangeListener((MutableSetChangeListener)this);
        }
        for (SimulationAutomaton simulationAutomaton : this.simulations.values()) {
            simulationAutomaton.terminate();
        }
    }

    public void insertDeleteQuery(SimulationResultData ard) {
        this.getArchMgr().getInQueuesMgr().insertInSimVarDeleteQueue(ard);
    }

    public long getWakeUpTime() {
        return this.wakeUpTime;
    }

    public void setTimeOutPeriod(long timeout) {
        this.wakeUpTime = timeout;
    }

    static sealed interface Transition
    permits SimulationAutomaton, WakeUpNow {
    }

    record WakeUpNow() implements Transition
    {
    }
}

