/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.simulation;

import de.bsvrz.ars.ars.mgmt.simulation.SimulationAutomaton;
import de.bsvrz.ars.ars.mgmt.simulation.SimulationManager;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.TreeSet;

class WakeUpManager {
    private final Hashtable<Long, ArrayList<SimulationAutomaton>> simulations = new Hashtable();
    private final Hashtable<SimulationAutomaton, ArrayList<SimulationAutomaton>> simList = new Hashtable();
    private final TreeSet<Long> minTime = new TreeSet();

    WakeUpManager() {
    }

    public synchronized void wakeUp() {
        Long wakeUpTime;
        while (!this.minTime.isEmpty() && (wakeUpTime = this.minTime.first()) <= System.currentTimeMillis()) {
            ArrayList<SimulationAutomaton> sims = this.simulations.remove(wakeUpTime);
            for (SimulationAutomaton sim : sims) {
                sim.wakeUp();
                this.simList.remove(sim);
            }
            sims.clear();
            this.minTime.remove(wakeUpTime);
        }
    }

    public synchronized void addWakeUp(SimulationManager simManager, SimulationAutomaton dfa, long wakeUpTime) {
        if (wakeUpTime > 0L && this.simList.get(dfa) == null) {
            ArrayList sims = this.simulations.computeIfAbsent(wakeUpTime, k -> new ArrayList());
            sims.add(dfa);
            this.simList.put(dfa, sims);
            if (this.minTime.isEmpty()) {
                this.minTime.add(wakeUpTime);
                simManager.addTransition(new SimulationManager.WakeUpNow());
            } else {
                Long first = this.minTime.first();
                if (first != wakeUpTime) {
                    this.minTime.add(wakeUpTime);
                    if (!first.equals(this.minTime.first())) {
                        simManager.addTransition(new SimulationManager.WakeUpNow());
                    }
                }
            }
        }
    }

    public synchronized void cancelWakeUp(SimulationAutomaton dfa) {
        ArrayList<SimulationAutomaton> sims = this.simList.remove(dfa);
        if (sims != null) {
            sims.remove(dfa);
        }
    }

    public synchronized long timeToWakeUp() {
        if (this.minTime.isEmpty()) {
            return 0L;
        }
        long time = this.minTime.first() - System.currentTimeMillis();
        return time < 1L ? 1L : time;
    }
}

