/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.TaskManager;
import de.bsvrz.ars.ars.mgmt.tasks.Task;
import de.bsvrz.ars.ars.mgmt.tasks.tasklistener.TaskStepListener;
import de.bsvrz.ars.ars.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class AbstractTask
extends Task {
    private final List<TaskStepListener> taskStepListeners = new ArrayList<TaskStepListener>();
    private String _name = this.getClass().getSimpleName();
    private volatile Thread _thread;
    private volatile boolean _isStarted;
    private volatile boolean _isTerminated;

    public AbstractTask(TaskManager archiveMgr) {
        super(archiveMgr);
    }

    public AbstractTask(PersistenceManager persistenceManager) {
        super(persistenceManager);
    }

    public final Thread.State getState() {
        Thread thread = this._thread;
        if (thread != null) {
            return thread.getState();
        }
        return Thread.State.NEW;
    }

    @Override
    public void start() {
        this._thread = new Thread(this::execute, this.getName());
        this._thread.start();
        this._isStarted = true;
    }

    protected void execute() {
        this._isTerminated = true;
    }

    protected void cleanUp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskStepListener(TaskStepListener tsl) {
        List<TaskStepListener> list = this.taskStepListeners;
        synchronized (list) {
            this.taskStepListeners.add(tsl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskStepListener(TaskStepListener tsl) {
        List<TaskStepListener> list = this.taskStepListeners;
        synchronized (list) {
            this.taskStepListeners.remove(tsl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void taskStepDone() {
        List<TaskStepListener> list = this.taskStepListeners;
        synchronized (list) {
            for (TaskStepListener tsl : this.taskStepListeners) {
                tsl.taskStepDone(this);
            }
        }
    }

    @Override
    public final String getName() {
        return this._name;
    }

    public final void setName(String name) {
        this._name = Objects.requireNonNull(name);
        Thread thread = this._thread;
        if (thread != null) {
            thread.setName(name);
        }
    }

    @Override
    public void join() throws InterruptedException {
        Thread thread = this._thread;
        if (thread != null) {
            thread.join();
        }
    }

    @Override
    public boolean isAlive() {
        return this._isStarted && !this._isTerminated;
    }

    @Override
    public boolean isTerminated() {
        return this._isTerminated;
    }
}

