/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.InQueuesMgr;
import de.bsvrz.ars.ars.mgmt.tasks.FlowControlTask;
import de.bsvrz.ars.ars.mgmt.tasks.MultiTaskManager;
import de.bsvrz.ars.ars.mgmt.tasks.Query;
import de.bsvrz.ars.ars.mgmt.tasks.QueryData;
import de.bsvrz.ars.ars.mgmt.tasks.QueryTask;
import de.bsvrz.ars.ars.mgmt.tasks.SimpleArchiveData;
import de.bsvrz.ars.ars.mgmt.tasks.Task;
import de.bsvrz.ars.ars.mgmt.tasks.base.TaskManager;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.archive.ArchiveDataSpecification;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.impl.archive.ArchiveDataCompression;
import de.bsvrz.sys.funclib.communicationStreams.StreamMultiplexer;
import de.bsvrz.sys.funclib.communicationStreams.StreamMultiplexerDirector;
import de.bsvrz.sys.funclib.dataSerializer.NoSuchVersionException;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.bsvrz.sys.funclib.losb.kernsoftware.ConnectionManager;
import java.io.IOException;

public class ArchiveQueryTask
extends QueryTask {
    private static final int BLOCKING_FACTOR_MUX_DEFAULT = 10;
    private static int blockingFactorMuxParam = 10;
    private int blockingFactorMuxUsed;
    private static final int BUFFER_SIZE_MUX_DEFAULT = 100000;
    private static int bufferSizeMuxParam = 100000;
    private int bufferSizeMuxUsed;
    private volatile StreamMultiplexer mux;
    private final FlowControlTask flowCtrl;
    private int receiverBufferSize;
    private boolean initialResponseSent;
    private final int maximumRequestsPerApplication;
    private Director _director;

    public ArchiveQueryTask(ArchiveManager archiveMgr, MultiTaskManager tMgr, FlowControlTask flowCtrl, int maximumRequestsPerApplication) {
        super(archiveMgr, tMgr);
        this.flowCtrl = flowCtrl;
        this.maximumRequestsPerApplication = maximumRequestsPerApplication;
    }

    public static void subscribeObjects(ArchiveManager archMgr, InQueuesMgr.DataReceiver receiver) {
        String atgPid = "atg.archivAnfrageSchnittstelle";
        String aspPid = "asp.anfrage";
        try {
            ConnectionManager.subscrDrainNormal((ClientDavInterface)archMgr.getDavCon(), (ClientReceiverInterface)receiver, (SystemObject)archMgr.getArchiveObject(), (String)atgPid, (String)aspPid);
        }
        catch (Exception e) {
            Debug.getLogger().error("Archivsystem konnte sich nicht als Senke f\u00fcr Archivanfragen anmelden: " + String.valueOf(archMgr.getArchiveObject()) + "/" + atgPid + "/" + aspPid + Debug.NEWLINE + e.getMessage());
        }
    }

    public static void setBlockingFactorMux(int bFMuxParam) {
        blockingFactorMuxParam = bFMuxParam;
    }

    public static void setBufferSizeMux(int bSMuxParam) {
        bufferSizeMuxParam = bSMuxParam;
    }

    public static int getBlockingFactorMux() {
        return blockingFactorMuxParam;
    }

    public static int getBufferSizeMux() {
        return bufferSizeMuxParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void work() {
        block15: {
            ArchiveDataSpecification[] ads;
            boolean counted;
            block14: {
                this.init();
                ArchiveManager archiveManager = this.getArchMgr();
                archiveManager.getPersistenceManager().assertNoLocks();
                counted = false;
                ads = this.analyze();
                if (this.queryAppObj != null) break block14;
                if (counted && this.queryAppObj != null) {
                    this.getArchMgr().decreaseArchiveQueryCountForApplication(this.queryAppObj);
                }
                this.unsubscribeSender();
                _debug.finer(this.getName() + " Archivanfrage beendet." + (this.initialResponseSent ? "" : " Wegen eines Fehlers konnte keine initiale Antwort gesendet werden"));
                return;
            }
            try {
                int archivQueryCountForApplication = this.getArchMgr().increaseArchiveQueryCountForApplication(this.queryAppObj);
                counted = true;
                this.sendingState = QueryTask.SendingState.STOP;
                this.subscribeSender();
                QueryTask.SendingState state = this.waitForSendControl();
                this.suspendTaskIfNecessary();
                TaskManager.run("Archivanfrage", tpi -> {
                    try (QueryData queries = QueryData.createQueryData(this.getArchMgr(), ads, archivQueryCountForApplication, this.maximumRequestsPerApplication, this.queryAppObj);){
                        if (queries.size() > 0) {
                            this.configureMuxParameter();
                            this._director = new Director(queries);
                            this.mux = new StreamMultiplexer(queries.size(), this.blockingFactorMuxUsed, this.bufferSizeMuxUsed, this.serializerVersion, (StreamMultiplexerDirector)this._director);
                            this.flowCtrl.subscribe(this.queryAppObj, this.queryIdx, this.mux);
                        }
                        if (state == QueryTask.SendingState.SEND) {
                            queries.sendReply(this::sendInitialResponse, this.mux);
                        }
                    }
                });
                if (counted && this.queryAppObj != null) {
                    this.getArchMgr().decreaseArchiveQueryCountForApplication(this.queryAppObj);
                }
                this.unsubscribeSender();
            }
            catch (InterruptedException e) {
                _debug.finer(this.getName() + ": Archivanfrage durch Interrupt beendet.");
                if (this.mux != null) {
                    this.mux.killAllStreams();
                }
                if (counted && this.queryAppObj != null) {
                    this.getArchMgr().decreaseArchiveQueryCountForApplication(this.queryAppObj);
                }
                this.unsubscribeSender();
                _debug.finer(this.getName() + " Archivanfrage beendet." + (this.initialResponseSent ? "" : " Wegen eines Fehlers konnte keine initiale Antwort gesendet werden"));
                break block15;
            }
            catch (Exception e2) {
                _debug.error(this.getName() + ": Fehler beim Bearbeiten der Archivanfrage: " + String.valueOf(this.resultData), (Throwable)e2);
                if (this.mux != null) {
                    this.mux.killAllStreams();
                }
                if (counted && this.queryAppObj != null) {
                    this.getArchMgr().decreaseArchiveQueryCountForApplication(this.queryAppObj);
                }
                this.unsubscribeSender();
                {
                    catch (Throwable throwable) {
                        if (counted && this.queryAppObj != null) {
                            this.getArchMgr().decreaseArchiveQueryCountForApplication(this.queryAppObj);
                        }
                        this.unsubscribeSender();
                        _debug.finer(this.getName() + " Archivanfrage beendet." + (this.initialResponseSent ? "" : " Wegen eines Fehlers konnte keine initiale Antwort gesendet werden"));
                        throw throwable;
                    }
                }
                _debug.finer(this.getName() + " Archivanfrage beendet." + (this.initialResponseSent ? "" : " Wegen eines Fehlers konnte keine initiale Antwort gesendet werden"));
            }
            _debug.finer(this.getName() + " Archivanfrage beendet." + (this.initialResponseSent ? "" : " Wegen eines Fehlers konnte keine initiale Antwort gesendet werden"));
        }
    }

    @Override
    public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
        if (this.sendingState == QueryTask.SendingState.SEND && state != 0) {
            this._director.killAllStreams();
        }
        super.dataRequest(object, dataDescription, state);
    }

    @Override
    public void terminateTask() {
        super.terminateTask();
        StreamMultiplexer mux = this.mux;
        if (mux != null) {
            mux.killAllStreams();
        }
    }

    @Override
    protected void cleanUp() {
        if (this.mux != null) {
            this.mux.killAllStreams();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.receiverBufferSize = 0;
        this.mux = null;
        this.blockingFactorMuxUsed = 0;
        this.bufferSizeMuxUsed = 0;
        this.initialResponseSent = false;
    }

    private ArchiveDataSpecification[] analyze() throws NoSuchVersionException, IOException {
        this.createQueryData();
        this.deserializer.readInt();
        this.receiverBufferSize = this.deserializer.readInt();
        return ArchiveQueryTask.parseArchiveDataSpec(this.deserializer, this.getArchMgr().getDataModel());
    }

    @Override
    protected void unsubscribeSender() {
        if (this.mux != null) {
            this.flowCtrl.unsubscribe(this.queryAppObj, this.queryIdx);
        }
        super.unsubscribeSender();
    }

    private void sendInitialResponse(boolean success, String errorMsg) throws IOException {
        this.bosResult.reset();
        this.serializer.writeByte(success ? 1 : 0);
        this.serializer.writeString(errorMsg);
        this.serializer.writeInt(this.blockingFactorMuxUsed);
        this.sendResultData(this.bosResult.toByteArray(), 2);
        this.initialResponseSent = true;
    }

    private void configureMuxParameter() {
        this.bufferSizeMuxUsed = bufferSizeMuxParam;
        this.blockingFactorMuxUsed = blockingFactorMuxParam;
        if (this.bufferSizeMuxUsed < 1) {
            this.bufferSizeMuxUsed = 1;
        }
        if (this.blockingFactorMuxUsed < 1) {
            this.blockingFactorMuxUsed = 1;
        }
        if (this.receiverBufferSize > 1) {
            if (this.receiverBufferSize >= this.bufferSizeMuxUsed) {
                this.blockingFactorMuxUsed = this.receiverBufferSize / this.bufferSizeMuxUsed;
            } else {
                this.blockingFactorMuxUsed = 1;
                this.bufferSizeMuxUsed = this.receiverBufferSize;
            }
        }
    }

    private class Director
    implements StreamMultiplexerDirector {
        private final QueryData queries;

        public Director(QueryData queries) {
            this.queries = queries;
        }

        public void sendData(byte[] streamDataPacket) {
            ArchiveQueryTask.this.sendResultData(streamDataPacket, 3);
        }

        @Nullable
        public byte[] take(int indexOfStream) {
            Query query = null;
            try {
                query = this.queries.get(indexOfStream);
                if (query.done) {
                    query.close();
                    return null;
                }
                SimpleArchiveData arcData = query.take();
                if (arcData == null) {
                    query.close();
                    return null;
                }
                ArchiveQueryTask.this.bosResult.reset();
                ArchiveQueryTask.this.serializer.writeInt(arcData.dataKind().getCode());
                ArchiveQueryTask.this.serializer.writeLong(arcData.dataTime());
                ArchiveQueryTask.this.serializer.writeLong(arcData.arcTime());
                ArchiveQueryTask.this.serializer.writeLong(arcData.dataIdx());
                ArchiveQueryTask.this.serializer.writeInt(arcData.dataState().getCode());
                ArchiveQueryTask.this.serializer.writeInt(ArchiveQueryTask.this.serializerVersion);
                ArchiveQueryTask.this.serializer.writeByte((int)(arcData.compressed() ? ArchiveDataCompression.ZIP.getCode() : ArchiveDataCompression.NONE.getCode()));
                if (arcData.rawData() != null) {
                    ArchiveQueryTask.this.serializer.writeInt(arcData.rawData().length);
                    ArchiveQueryTask.this.serializer.writeBytes(arcData.rawData());
                } else {
                    ArchiveQueryTask.this.serializer.writeInt(0);
                }
                return ArchiveQueryTask.this.bosResult.toByteArray();
            }
            catch (Exception e) {
                Task._debug.error(ArchiveQueryTask.this.getName() + ": Unterabfrage " + indexOfStream + ": Erstellung Datensatz fuer Archivantwort fehlgeschlagen.", (Throwable)e);
                if (query != null) {
                    query.done = true;
                }
                return null;
            }
        }

        public void streamAborted(int indexOfStream) {
            Task._debug.finest(ArchiveQueryTask.this.getName() + " QueryTask verwirft Stream mit Index " + indexOfStream);
            if (indexOfStream >= 0 && indexOfStream < this.queries.size()) {
                this.queries.get((int)indexOfStream).done = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void killAllStreams() {
            QueryData queryData = this.queries;
            synchronized (queryData) {
                if (ArchiveQueryTask.this.mux != null) {
                    ArchiveQueryTask.this.mux.killAllStreams();
                }
            }
        }
    }

    public static interface ResponseSender {
        public void sendInitialResponse(boolean var1, String var2) throws IOException;
    }
}

