/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.InQueuesMgr;
import de.bsvrz.ars.ars.mgmt.tasks.ArchiveQueryTask;
import de.bsvrz.ars.ars.mgmt.tasks.SingleTask;
import de.bsvrz.ars.ars.persistence.writer.ArchiveTask;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.losb.datk.ArchiveSettings;
import de.bsvrz.sys.funclib.losb.datk.ContainerSettings;
import de.bsvrz.sys.funclib.losb.kernsoftware.ConnectionManager;
import java.util.ArrayList;
import java.util.List;

public class ArchiveSettingsTask
extends SingleTask {
    private static final String SETTINGS_ASPECT = "asp.parameterSoll";
    public static final int MIN_CONTAINER_MAXDS = 1;
    public static final int MIN_CONTAINER_MAXSIZE = 4096;
    public static final int MIN_CONTAINER_MAXTIME = 60;
    public static final int ARCHIVEINST = 0;
    public static final int ARCHIVCONTAINER = 1;
    private static final String[][] SUBSCR_PIDS = new String[][]{{"atg.archivEinstellung", "asp.parameterSoll"}, {"atg.archivContainer", "asp.parameterSoll"}};
    private static final long[] SUBSCR_IDS = new long[SUBSCR_PIDS.length];
    private final List<ArSSettingListener>[] settingsListener = new List[SUBSCR_PIDS.length];

    public ArchiveSettingsTask(ArchiveManager archMgr) {
        super(archMgr);
        for (int i = 0; i < this.settingsListener.length; ++i) {
            this.settingsListener[i] = new ArrayList<ArSSettingListener>();
        }
    }

    public static void subscribeObjects(ArchiveManager archMgr, InQueuesMgr.DataReceiver receiver) {
        for (int i = 0; i < SUBSCR_IDS.length; ++i) {
            try {
                ArchiveSettingsTask.SUBSCR_IDS[i] = archMgr.getAtg(SUBSCR_PIDS[i][0]).getId();
                ConnectionManager.subscrRecNormal((ClientDavInterface)archMgr.getDavCon(), (ClientReceiverInterface)receiver, (SystemObject)archMgr.getArchiveObject(), (String)SUBSCR_PIDS[i][0], (String)SUBSCR_PIDS[i][1]);
                Debug.getLogger().fine("Archiveinstellungen angemeldet: " + SUBSCR_PIDS[i][0] + "/" + SUBSCR_PIDS[i][1]);
                continue;
            }
            catch (Exception e) {
                Debug.getLogger().error("Anmeldung fuer KV-Objekt fehlgeschlagen: " + SUBSCR_PIDS[i][0] + "/" + SUBSCR_PIDS[i][1] + Debug.NEWLINE + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArSSettingListener createSettingLstnr(int subscription) {
        ArSSettingListener eosl = new ArSSettingListener();
        List<ArSSettingListener> list = this.settingsListener[subscription];
        synchronized (list) {
            this.settingsListener[subscription].add(eosl);
        }
        return eosl;
    }

    @Override
    protected void work(ResultData resultData) {
        long atgID = resultData.getDataDescription().getAttributeGroup().getId();
        if (atgID == SUBSCR_IDS[0]) {
            _debug.info("Neue Archiveinstellungen erhalten" + Debug.NEWLINE, (Object)resultData.toString());
            ArchiveSettings as = new ArchiveSettings(resultData.getData());
            this.getArchMgr().getInQueuesMgr().getArchiveDataReceiver().setTMaxATimeForwardStep(as.maxATimeLeap);
            this.getArchMgr().getTaskScheduler().setIntervals(as.nachfIntervall);
            ArchiveQueryTask.setBlockingFactorMux(as.queryAnzBlocks);
            ArchiveQueryTask.setBufferSizeMux(as.queryAnzBytes);
            this.getArchMgr().getInQueuesMgr().setQueryTaskNumbers(as.anzHohePrio, as.anzMittPrio, as.anzNiedPrio);
            this.getArchMgr().getSimulationMgr().setTimeOutPeriod(as.timeoutSteuerbefehl);
            this.notifyListener(0);
        } else if (atgID == SUBSCR_IDS[1]) {
            _debug.info("Neue Containereinstellungen erhalten" + Debug.NEWLINE, (Object)resultData.toString());
            ContainerSettings cs = new ContainerSettings(resultData.getData());
            boolean minimumsCorrected = cs.ensureMinimums(1, 4096, 60L);
            if (minimumsCorrected) {
                _debug.warning("Einstellungen fuer [" + SUBSCR_PIDS[1][0] + "/" + SUBSCR_PIDS[1][1] + "] enthaelt Wert unter Minimum\n(min. MaxAnzahlArchivdatens\u00e4tze=1, min. MaxContainergroesse=4096 Bytes, min. MaxZeitspanneContainer=60sec)\n", (Object)resultData.getData());
            }
            ArchiveTask.setContainerSettings(cs);
            this.notifyListener(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener(int subscr) {
        List<ArSSettingListener> list = this.settingsListener[subscr];
        synchronized (list) {
            for (int i = 0; i < this.settingsListener[subscr].size(); ++i) {
                this.settingsListener[subscr].get(i).gotSettings();
            }
            this.settingsListener[subscr].clear();
        }
    }

    public static class ArSSettingListener {
        private boolean gotSettings;

        private ArSSettingListener() {
        }

        public synchronized void gotSettings() {
            this.gotSettings = true;
            this.notifyAll();
        }

        public synchronized void waitForSettings() throws InterruptedException {
            while (!this.gotSettings) {
                this.wait();
            }
        }
    }
}

