/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.LongTermTaskStatePublisher;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.mgmt.tasks.QueueTask;
import de.bsvrz.ars.ars.mgmt.tasks.Task;
import de.bsvrz.ars.ars.mgmt.tasks.base.TaskManager;
import de.bsvrz.ars.ars.mgmt.tasks.base.TaskState;
import de.bsvrz.ars.ars.persistence.ContainerFile;
import de.bsvrz.ars.ars.persistence.ContainerHeaders;
import de.bsvrz.ars.ars.persistence.ContainerManagementInformation;
import de.bsvrz.ars.ars.persistence.DataIdentificationDir;
import de.bsvrz.ars.ars.persistence.DeletedContainerFile;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.util.SignalingQueue;
import de.bsvrz.ars.ars.persistence.walk.ContainerAction;
import de.bsvrz.ars.ars.persistence.walk.ContainerWalk;
import de.bsvrz.ars.ars.persistence.walk.internal.StatusPrinter;
import de.bsvrz.dav.daf.main.archive.ArchiveDataSpecification;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class DeletePermanentlyTask
extends QueueTask<DeletePermanentlyToken> {
    private final de.bsvrz.ars.ars.mgmt.tasks.base.Task _longTermTaskStatePublisherTask;
    private final AtomicInteger _numOfDeletedCont = new AtomicInteger();
    private final int _numThreads;

    public DeletePermanentlyTask(ArchiveManager archiveMgr, LongTermTaskStatePublisher longTermTaskStatePublisher, int numThreads) {
        super(archiveMgr, new SignalingQueue());
        this.setName("Endg\u00fcltiges L\u00f6schen");
        this._longTermTaskStatePublisherTask = longTermTaskStatePublisher.registerTask("Endg\u00fcltiges L\u00f6schen");
        this._numThreads = numThreads;
    }

    @Override
    protected void work(DeletePermanentlyToken step) {
        try {
            TaskManager.run(this._longTermTaskStatePublisherTask, tpi -> this.containerWalk(new ArchiveDataSpecification[0], new DeletePermanently()));
            this._longTermTaskStatePublisherTask.setTaskState(TaskState.IDLE);
        }
        catch (Exception e) {
            _debug.error("Endg\u00fcltiges L\u00f6schen fehlgeschlagen", (Throwable)e);
        }
    }

    private void containerWalk(ArchiveDataSpecification[] ads, ContainerHandler handler) throws Exception {
        this._numOfDeletedCont.set(0);
        if (ads.length == 0) {
            this.doContainerWalk(handler, ContainerWalk.allContainers(this.getPersistenceManager().getActivePersistenceDirectory(0), this.getPersistenceManager()));
        } else {
            this.doContainerWalk(handler, ContainerWalk.fromArchiveDataSpecification(this.getPersistenceManager().getActivePersistenceDirectory(0), Arrays.asList(ads), this.getPersistenceManager()));
        }
    }

    private void doContainerWalk(final ContainerHandler handler, final ContainerWalk containerWalk) throws PersistenceException {
        containerWalk.setStatusPrinter(handler.getStatusPrinter());
        containerWalk.execute(handler.getActionName(), this._numThreads, new ContainerAction(){

            @Override
            public void preVisitDirectory(DataIdentificationDir dataIdentificationDir) {
                if (DeletePermanentlyTask.this.shouldTerminate()) {
                    containerWalk.terminate();
                }
                DeletePermanentlyTask.this.suspendTaskIfNecessary();
            }

            @Override
            public void run(DataIdentificationDir containerFileDir, LockedContainerDirectory containerDirectory, Collection<ContainerHeaders> headers) throws Exception {
                List<ContainerHeaders> containersToHandle = headers.stream().filter(it -> handler.appliesTo(containerFileDir.getDataIdentification(), (ContainerHeaders)it)).collect(Collectors.toList());
                if (!containersToHandle.isEmpty()) {
                    handler.handleContainers(containerDirectory, containerFileDir.getPersistenceDirectory(), containersToHandle);
                }
            }
        });
    }

    private static interface ContainerHandler {
        public void handleContainers(LockedContainerDirectory var1, PersistenceDirectory var2, Collection<ContainerHeaders> var3) throws PersistenceException, SynchronizationFailedException, IndexException;

        public boolean appliesTo(IdDataIdentification var1, ContainerHeaders var2);

        public String getActionName();

        public StatusPrinter getStatusPrinter();
    }

    public static class DeletePermanentlyToken {
    }

    public class DeletePermanently
    implements ContainerHandler {
        private final boolean simulatePermanentDelete;

        public DeletePermanently() {
            this.simulatePermanentDelete = DeletePermanentlyTask.this.getArchMgr().simulatePermanentDelete();
        }

        @Override
        public void handleContainers(LockedContainerDirectory directory, PersistenceDirectory persistenceDirectory, Collection<ContainerHeaders> headers) throws PersistenceException, SynchronizationFailedException, IndexException {
            DeletedContainerFile deletedContainerFile = null;
            if (headers.isEmpty()) {
                return;
            }
            if (this.simulatePermanentDelete) {
                long min = headers.stream().mapToLong(it -> it.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_ARC_TIME_MIN)).min().orElseThrow();
                long max = headers.stream().mapToLong(it -> it.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_ARC_TIME_MAX)).max().orElseThrow();
                Task._debug.info("Das endg\u00fcltige L\u00f6schen w\u00fcrde " + headers.size() + " Container der Datenidentifikation " + DeletePermanentlyTask.this.getPersistenceManager().formatContainerDirectory(directory) + " mit dem Archivzeitbereich " + String.valueOf(Instant.ofEpochMilli(min)) + " bis " + String.valueOf(Instant.ofEpochMilli(max)) + " l\u00f6schen. Um das Endg\u00fcltige L\u00f6schen zu aktivieren bitte Archivsystem mit -permanentLoeschen=ja starten, oder das L\u00f6schen \u00fcber Telnet aktivieren.");
                DeletePermanentlyTask.this._numOfDeletedCont.getAndIncrement();
                return;
            }
            for (ContainerHeaders header : headers) {
                long containerId = header.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_CONT_ID);
                try {
                    persistenceDirectory.removeContainerFromIndex(directory, containerId);
                    if (header.getContainerHeaderParamAsBoolean(ContainerManagementInformation.CHP_DELETED)) {
                        if (deletedContainerFile == null) {
                            deletedContainerFile = persistenceDirectory.openDeletedContainerFile(directory);
                        }
                        deletedContainerFile.removeDeletedContainer(containerId);
                    } else {
                        Path contFile = persistenceDirectory.getPath(directory).resolve(ContainerFile.getContainerFileName(containerId));
                        Files.delete(contFile);
                    }
                }
                catch (IOException e) {
                    Task._debug.warning("Container " + containerId + " in " + String.valueOf(directory) + " konnte nicht endg\u00fcltig gel\u00f6scht werden", (Throwable)e);
                    return;
                }
                DeletePermanentlyTask.this._numOfDeletedCont.getAndIncrement();
            }
            if (deletedContainerFile != null) {
                deletedContainerFile.write();
            }
        }

        @Override
        public boolean appliesTo(IdDataIdentification dataIdentification, ContainerHeaders headers) {
            if (this.simulatePermanentDelete) {
                DeletePermanentlyTask.this._longTermTaskStatePublisherTask.setTaskProgress("Endg\u00fcltiges L\u00f6schen: %1$d Container w\u00e4ren gel\u00f6scht worden", DeletePermanentlyTask.this._numOfDeletedCont.get(), -1L, -1L);
            } else {
                DeletePermanentlyTask.this._longTermTaskStatePublisherTask.setTaskProgress("Endg\u00fcltiges L\u00f6schen: %1$d Container gel\u00f6scht", DeletePermanentlyTask.this._numOfDeletedCont.get(), -1L, -1L);
            }
            long maxArcTime = headers.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_ARC_TIME_MAX);
            if (maxArcTime == 0L) {
                return false;
            }
            long permanentDeleteTimeSeconds = DeletePermanentlyTask.this.getArchMgr().getArchivConfig().getPermanentDeleteTimeSeconds(DeletePermanentlyTask.this.getDidTree().get(dataIdentification));
            if (permanentDeleteTimeSeconds <= 0L) {
                return false;
            }
            long systemTime = DeletePermanentlyTask.this.getArchMgr().getInQueuesMgr().getRuntimeControl().getSystemTime();
            return maxArcTime + 1000L * permanentDeleteTimeSeconds < systemTime;
        }

        @Override
        public String getActionName() {
            return "Endg\u00fcltiges L\u00f6schen";
        }

        @Override
        public StatusPrinter getStatusPrinter() {
            return new StatusPrinter(){

                @Override
                public String getStatusMessage(String actionName, Duration runtime, StatusPrinter.ApproximationType approximationType, long allContainerDirs, long visitedContainerDirs, long visitedContainerFiles) {
                    if (DeletePermanently.this.simulatePermanentDelete) {
                        return super.getStatusMessage(actionName, runtime, approximationType, allContainerDirs, visitedContainerDirs, visitedContainerFiles) + " " + DeletePermanentlyTask.this._numOfDeletedCont.get() + " Container w\u00e4ren gel\u00f6scht worden.";
                    }
                    return super.getStatusMessage(actionName, runtime, approximationType, allContainerDirs, visitedContainerDirs, visitedContainerFiles) + " " + DeletePermanentlyTask.this._numOfDeletedCont.get() + " Container gel\u00f6scht.";
                }

                @Override
                public String getSuccessMessage(String actionName, Duration runtime, long visitedContainerDirs, long visitedContainerFiles) {
                    if (DeletePermanently.this.simulatePermanentDelete) {
                        return super.getSuccessMessage(actionName, runtime, visitedContainerDirs, visitedContainerFiles) + " " + DeletePermanentlyTask.this._numOfDeletedCont.get() + " Container w\u00e4ren gel\u00f6scht worden.";
                    }
                    return super.getSuccessMessage(actionName, runtime, visitedContainerDirs, visitedContainerFiles) + " " + DeletePermanentlyTask.this._numOfDeletedCont.get() + " Container gel\u00f6scht.";
                }
            };
        }
    }
}

