/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SyncKey;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.mgmt.simulation.SimulationResultData;
import de.bsvrz.ars.ars.mgmt.tasks.SingleTask;
import de.bsvrz.ars.ars.mgmt.tasks.query.QueryHandler;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.directories.ActivePersistenceDirectory;
import de.bsvrz.ars.ars.persistence.walk.DataIdentificationDirWalk;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.sys.funclib.dataSerializer.NoSuchVersionException;
import java.io.IOException;

public class DeleteSimVarTask
extends SingleTask {
    public DeleteSimVarTask(ArchiveManager archiveMgr) {
        super(archiveMgr);
    }

    @Override
    protected void work(ResultData resultData) {
        if (resultData != null) {
            if (resultData instanceof SimulationResultData) {
                try {
                    this.deleteSimVarSimulation((SimulationResultData)resultData);
                }
                catch (PersistenceException e) {
                    _debug.warning("Fehler beim L\u00f6schen. " + e.getMessage());
                }
            } else if (resultData.hasData()) {
                this.deleteSimVarClient(resultData);
            }
        }
    }

    private void deleteSimVarSimulation(SimulationResultData srd) throws PersistenceException {
        boolean successful = false;
        try {
            this.executeDelete(srd.getSimVar());
            successful = true;
        }
        finally {
            srd.dataDeleted(successful);
        }
    }

    private void deleteSimVarClient(ResultData resultData) {
        QueryHandler queryHandler = new QueryHandler(this.getName(), this.getArchMgr(), 8, resultData.getData());
        try {
            short simVarToDelete = queryHandler.getDeserializer().readShort();
            this.executeDelete(simVarToDelete);
            queryHandler.sendSuccessResponse();
        }
        catch (NoSuchVersionException e) {
            String msg = "Geforderte Version Serialisierers/Deserialisierers nicht verfuegbar. " + e.getMessage();
            _debug.warning(msg);
            queryHandler.sendErrorResponse(msg);
        }
        catch (IOException e) {
            String msg = "Fehler beim Deserialisieren. " + e.getMessage();
            _debug.warning(msg);
            queryHandler.sendErrorResponse(msg);
        }
        catch (PersistenceException e) {
            String msg = "Fehler beim L\u00f6schen. " + e.getMessage();
            _debug.warning(msg);
            queryHandler.sendErrorResponse(msg);
        }
    }

    private void executeDelete(short simVarToDelete) throws PersistenceException {
        if (simVarToDelete == 0) {
            throw new PersistenceException("Ung\u00fcltige Simulationsvariante");
        }
        ActivePersistenceDirectory directory = this.getPersistenceManager().getActivePersistenceDirectory(simVarToDelete);
        if (directory == null) {
            return;
        }
        DataIdentificationDirWalk.allDirectories(directory).execute("Simulationsvariante " + simVarToDelete + " L\u00f6schen", 1, (dataIdentificationDir, walk) -> {
            IdDataIdentification di = dataIdentificationDir.getDataIdentification();
            if (di.getSimVariant() == simVarToDelete) {
                try {
                    ArchiveManager archiveManager = this.getArchMgr();
                    try (SyncKey<IdDataIdentification> syncKey = archiveManager.getPersistenceManager().lockIndex(di);){
                        this.getPersistenceManager().deleteSimVar(syncKey);
                        this.getDidTree().deleteDataIdentNode(di);
                    }
                }
                catch (SynchronizationFailedException e) {
                    _debug.warning("Loeschen eines DataIdentNodes fehlgeschlagen fuer DIN " + String.valueOf(di), (Throwable)e);
                }
            }
        });
        this.getPersistenceManager().deletePersistenceDirectory(directory);
    }
}

