/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.tasks.AbstractTask;
import de.bsvrz.ars.ars.mgmt.tasks.MultiTask;
import de.bsvrz.ars.ars.mgmt.tasks.QueueTask;
import de.bsvrz.ars.ars.persistence.util.SignalingQueue;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.sys.funclib.losb.ringbuffer.RingBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class MultiTaskManager
extends QueueTask<ResultData> {
    private final RingBuffer<MultiTask> freeTaskQueue;
    private final ArrayList<MultiTask> taskList = new ArrayList();
    private final AtomicInteger adjustTaskNumFactor = new AtomicInteger(0);

    public MultiTaskManager(ArchiveManager archiveMgr, SignalingQueue<ResultData> inputData, String taskName) {
        super(archiveMgr, inputData);
        this.setName(this.getName() + "[" + taskName + "]");
        this.freeTaskQueue = new RingBuffer(16, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        ArrayList<MultiTask> arrayList = this.taskList;
        synchronized (arrayList) {
            for (MultiTask task : this.taskList) {
                task.start();
            }
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTask(MultiTask task) {
        if (this.shouldTerminate()) {
            return;
        }
        ArrayList<MultiTask> arrayList = this.taskList;
        synchronized (arrayList) {
            this.taskList.add(task);
            task.setTaskIndex(this.taskList.size() - 1);
        }
        ArchiveManager archMgr = this.getArchMgr();
        if (archMgr != null && archMgr.getDataModel() != null) {
            task.getObjectsFromDav();
        }
        if (this.getState() != Thread.State.NEW && this.getState() != Thread.State.TERMINATED) {
            task.start();
        }
        this.pushFreeTask(task);
    }

    public synchronized void removeTask() {
        if (this.getTaskNum() > 1) {
            this.adjustTaskNumFactor.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTaskNum() {
        ArrayList<MultiTask> arrayList = this.taskList;
        synchronized (arrayList) {
            return this.taskList.size() - this.adjustTaskNumFactor.get();
        }
    }

    void pushFreeTask(MultiTask task) {
        if (!this.shouldTerminate()) {
            this.freeTaskQueue.push((Object)task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanUp() {
        ArrayList<MultiTask> arrayList = this.taskList;
        synchronized (arrayList) {
            for (MultiTask task : this.taskList) {
                task.terminateTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void work(ResultData step) throws InterruptedException {
        MultiTask nextWorkingTask;
        while (true) {
            nextWorkingTask = (MultiTask)this.freeTaskQueue.pop();
            if (this.adjustTaskNumFactor.get() > 0) {
                this.adjustTaskNumFactor.decrementAndGet();
                nextWorkingTask.terminateTask();
                ArrayList<MultiTask> arrayList = this.taskList;
                synchronized (arrayList) {
                    this.taskList.remove(nextWorkingTask);
                }
            }
            if (!nextWorkingTask.shouldTerminate()) break;
        }
        nextWorkingTask.submit(step);
        this.taskStepDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join() throws InterruptedException {
        ArrayList<MultiTask> tmp;
        ArrayList<MultiTask> arrayList = this.taskList;
        synchronized (arrayList) {
            tmp = new ArrayList<MultiTask>(this.taskList);
        }
        for (MultiTask multiTask : tmp) {
            multiTask.join();
        }
        super.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder(2048);
        ArrayList<MultiTask> arrayList = this.taskList;
        synchronized (arrayList) {
            for (MultiTask mt : this.taskList) {
                sb.append((String)(mt != null ? mt.getName() + ":  " + String.valueOf((Object)mt.getState()) : "null"));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isAlive() {
        return super.isAlive() || this.taskList.stream().anyMatch(AbstractTask::isAlive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getObjectsFromDav() {
        ArrayList<MultiTask> arrayList = this.taskList;
        synchronized (arrayList) {
            for (MultiTask multiTask : this.taskList) {
                multiTask.getObjectsFromDav();
            }
        }
    }
}

