/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.tasks.SingleTask;
import de.bsvrz.ars.ars.mgmt.tasks.query.QueryHandler;
import de.bsvrz.dav.daf.main.ResultData;

public class NumQueriesInfoTask
extends SingleTask {
    public NumQueriesInfoTask(ArchiveManager archMgr) {
        super(archMgr);
    }

    @Override
    protected void work(ResultData resultData) {
        if (!resultData.hasData()) {
            return;
        }
        QueryHandler queryHandler = new QueryHandler(this.getName(), this.getArchMgr(), 22, resultData.getData());
        try {
            int requestType = queryHandler.getDeserializer().readInt();
            if (requestType != 0) {
                queryHandler.sendErrorResponse("Unbekannter Anfrage-Typ: " + requestType + " (Archivsystem aktualisieren?)");
            }
            queryHandler.sendResponse(22, true, "", serializer -> {
                serializer.writeInt(this.getArchMgr().getMaximumQueriesPerApplication());
                serializer.writeInt(this.getArchMgr().getArchiveQueryCountForApplication(queryHandler.getQueryApplication()));
            });
        }
        catch (Exception e) {
            _debug.error("Abfrage Anzahl gleichzeitiger Archivanfragen fehlgeschlagen", (Throwable)e);
            queryHandler.sendErrorResponse("Abfrage Anzahl gleichzeitiger Archivanfragen: " + e.getMessage());
        }
    }
}

