/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.tasks.ArchiveQueryTask;
import de.bsvrz.ars.ars.mgmt.tasks.Query;
import de.bsvrz.ars.ars.mgmt.tasks.QueryData;
import de.bsvrz.dav.daf.main.archive.ArchiveDataSpecification;
import de.bsvrz.sys.funclib.communicationStreams.StreamMultiplexer;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class QueryList
implements QueryData {
    private static final Debug _debug = Debug.getLogger();
    private final List<Query> queries = new ArrayList<Query>();

    QueryList(ArchiveManager archMgr, ArchiveDataSpecification[] ads) {
        try {
            for (int i = 0; i < ads.length; ++i) {
                boolean intervalErr = ads[i].getTimeSpec().getIntervalStart() > ads[i].getTimeSpec().getIntervalEnd();
                this.queries.add(i, new Query(archMgr, ads[i], intervalErr));
            }
        }
        catch (Throwable e) {
            this.close();
            _debug.error("Fehler beim Initialisieren der QueryList", e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List<Query> list = this.queries;
        synchronized (list) {
            for (Query query : this.queries) {
                try {
                    query.close();
                }
                catch (Exception e) {
                    _debug.warning("Fehler beim Schlie\u00dfen eines Archivanfragen-Iterators", (Throwable)e);
                }
            }
        }
    }

    @Override
    public int size() {
        return this.queries.size();
    }

    @Override
    public void sendReply(ArchiveQueryTask.ResponseSender sender, StreamMultiplexer mux) throws IOException, InterruptedException {
        sender.sendInitialResponse(true, "");
        if (mux != null) {
            mux.sendAllStreamData();
        }
    }

    @Override
    public Query get(int indexOfStream) {
        return this.queries.get(indexOfStream);
    }
}

