/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.tasks.MultiTask;
import de.bsvrz.ars.ars.mgmt.tasks.MultiTaskManager;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKindCombination;
import de.bsvrz.dav.daf.main.archive.ArchiveDataSpecification;
import de.bsvrz.dav.daf.main.archive.ArchiveOrder;
import de.bsvrz.dav.daf.main.archive.ArchiveRequestOption;
import de.bsvrz.dav.daf.main.archive.ArchiveTimeSpecification;
import de.bsvrz.dav.daf.main.archive.TimingType;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.ObjectLookup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.dataSerializer.Deserializer;
import de.bsvrz.sys.funclib.dataSerializer.NoSuchVersionException;
import de.bsvrz.sys.funclib.dataSerializer.Serializer;
import de.bsvrz.sys.funclib.dataSerializer.SerializingFactory;
import de.bsvrz.sys.funclib.losb.kernsoftware.ConnectionManager;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class QueryTask
extends MultiTask
implements ClientSenderInterface {
    protected SendingState sendingState;
    protected final Object syncObj = new Object();
    protected SystemObject queryAppObj;
    protected AttributeGroup atgQuery;
    protected DataDescription ddResponse;
    protected int queryIdx;
    protected int serializerVersion;
    protected Data gData;
    protected ResultData gResultData;
    protected final ByteArrayOutputStream bosResult = new ByteArrayOutputStream(16384);
    protected Serializer serializer;
    protected Deserializer deserializer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SendingState waitForSendControl() throws InterruptedException {
        SendingState state;
        long timeoutTime = System.currentTimeMillis() + 60000L;
        Object object = this.syncObj;
        synchronized (object) {
            long delta;
            while (this.sendingState == SendingState.STOP && (delta = timeoutTime - System.currentTimeMillis()) > 0L) {
                this.syncObj.wait(delta);
            }
            state = this.sendingState;
        }
        return state;
    }

    public QueryTask(ArchiveManager archiveMgr, MultiTaskManager tMgr) {
        super(archiveMgr, tMgr);
    }

    @Override
    public void getObjectsFromDav() {
        DataModel dataModel = this.getArchMgr().getDataModel();
        if (dataModel == null) {
            throw new IllegalStateException();
        }
        this.atgQuery = dataModel.getAttributeGroup("atg.archivAnfrageSchnittstelle");
        this.ddResponse = new DataDescription(this.atgQuery, dataModel.getAspect("asp.antwort"));
    }

    protected void init() {
        this.queryAppObj = null;
        this.queryIdx = 0;
        this.serializerVersion = 0;
        this.sendingState = SendingState.STOP;
    }

    public boolean isRequestSupported(SystemObject object, DataDescription dataDescription) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
        Object object2 = this.syncObj;
        synchronized (object2) {
            this.sendingState = state == 0 ? SendingState.SEND : (this.sendingState == SendingState.SEND ? SendingState.ABORT : SendingState.STOP);
            this.syncObj.notifyAll();
        }
    }

    protected void subscribeSender() throws OneSubscriptionPerSendData {
        ConnectionManager.subscribeSender((ClientDavInterface)this.getArchMgr().getDavCon(), (ClientSenderInterface)this, (SystemObject)this.queryAppObj, (DataDescription)this.ddResponse, (SenderRole)SenderRole.sender());
    }

    protected void unsubscribeSender() {
        try {
            ConnectionManager.unsubscribeSender((ClientDavInterface)this.getArchMgr().getDavCon(), (ClientSenderInterface)this, (SystemObject)this.queryAppObj, (DataDescription)this.ddResponse);
        }
        catch (Exception e) {
            _debug.warning(this.getName() + " Sende-Abmeldung fehlgeschlagen.", (Throwable)e);
        }
    }

    protected void createQueryData() throws NoSuchVersionException {
        this.queryAppObj = this.resultData.getData().getReferenceValue("absender").getSystemObject();
        this.queryIdx = this.resultData.getData().getUnscaledValue("anfrageIndex").intValue();
        this.gData = this.getArchMgr().getDavCon().createData(this.atgQuery);
        this.gData.getReferenceValue("absender").setSystemObject((SystemObject)this.getArchMgr().getArchiveObject());
        this.gData.getItem("anfrageIndex").asUnscaledValue().set(this.queryIdx);
        byte[] dataArray = this.resultData.getData().getUnscaledArray("daten").getByteArray();
        this.serializerVersion = Util.getSerVersion((byte[])dataArray);
        this.bosResult.reset();
        this.serializer = SerializingFactory.createSerializer((int)this.serializerVersion, (OutputStream)this.bosResult);
        ByteArrayInputStream stream = new ByteArrayInputStream(dataArray, 4, dataArray.length - 4);
        this.deserializer = SerializingFactory.createDeserializer((int)this.serializerVersion, (InputStream)stream);
        this.gResultData = new ResultData(this.queryAppObj, this.ddResponse, 0L, this.gData);
    }

    protected void sendResultData(byte[] resultBytes, int msgType) {
        try {
            this.gData.getItem("nachrichtenTyp").asUnscaledValue().set(msgType);
            Data.Array data = this.gData.getArray("daten");
            data.setLength(resultBytes.length);
            for (int i = 0; i < resultBytes.length; ++i) {
                data.getItem(i).asUnscaledValue().set((int)resultBytes[i]);
            }
            this.gResultData.setDataTime(System.currentTimeMillis());
            this.getArchMgr().getDavCon().sendData(this.gResultData);
        }
        catch (Exception e) {
            _debug.error(this.getName() + " Daten-Versand an Empfaenger-Applikations-Objekt fehlgeschlagen", (Throwable)e);
        }
    }

    protected static ArchiveDataSpecification[] parseArchiveDataSpec(Deserializer ds, DataModel dataModel) throws IOException {
        int anzQueries = ds.readInt();
        ArchiveDataSpecification[] result = new ArchiveDataSpecification[anzQueries];
        for (int i = 0; i < anzQueries; ++i) {
            TimingType tt = Util.getTimingType((int)ds.readByte());
            boolean relative = ds.readByte() == 1;
            long start = ds.readLong();
            long end = ds.readLong();
            ArchiveTimeSpecification timeSpec = new ArchiveTimeSpecification(tt, relative, start, end);
            boolean oa = ds.readByte() == 1;
            boolean on = ds.readByte() == 1;
            boolean na = ds.readByte() == 1;
            boolean nn = ds.readByte() == 1;
            ArchiveDataKindCombination adkComb = Util.getADKCombination((boolean)oa, (boolean)on, (boolean)na, (boolean)nn);
            int orderCode = ds.readInt();
            ArchiveOrder order = orderCode != 0 ? ArchiveOrder.getInstance((int)orderCode) : null;
            int reqOptCode = ds.readInt();
            ArchiveRequestOption reqOpt = reqOptCode != 0 ? ArchiveRequestOption.getInstance((int)reqOptCode) : null;
            AttributeGroup atg = (AttributeGroup)ds.readObjectReference((ObjectLookup)dataModel);
            Aspect asp = (Aspect)ds.readObjectReference((ObjectLookup)dataModel);
            short sv = ds.readShort();
            SystemObject obj = ds.readObjectReference((ObjectLookup)dataModel);
            result[i] = new ArchiveDataSpecification(timeSpec, adkComb, order, reqOpt, new DataDescription(atg, asp, sv), obj);
        }
        return result;
    }

    protected static enum SendingState {
        SEND,
        STOP,
        ABORT;

    }
}

